/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;
import utility.UtilTso;
import zostso.CollectedResponses;
import zostso.SendResponse;
import zostso.input.SendTsoParams;
import zostso.zosmf.TsoMessage;
import zostso.zosmf.TsoMessages;
import zostso.zosmf.TsoResponseMessage;
import zostso.zosmf.ZosmfTsoResponse;

public class SendTso {
    private static final Logger LOG = LogManager.getLogger(SendTso.class);
    private final ZOSConnection connection;

    public SendTso(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public SendResponse sendDataToTSOCollect(String servletKey, String data) throws Exception {
        Util.checkNullParameter(servletKey == null, "servletKey is null");
        Util.checkNullParameter(data == null, "data is null");
        Util.checkIllegalParameter(servletKey.isEmpty(), "servletKey not specified");
        Util.checkIllegalParameter(data.isEmpty(), "data not specified");
        ZosmfTsoResponse putResponse = this.sendDataToTSOCommon(new SendTsoParams(servletKey, data));
        CollectedResponses responses = this.getAllResponses(putResponse);
        return SendTso.createResponse(responses);
    }

    public ZosmfTsoResponse sendDataToTSOCommon(SendTsoParams commandParams) throws Exception {
        Util.checkNullParameter(commandParams == null, "commandParams is null");
        Util.checkIllegalParameter(commandParams.getData().isEmpty(), "commandParams data not specified");
        Util.checkIllegalParameter(commandParams.getServletKey().isEmpty(), "commandParams servletKey not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/tsoApp/tso/" + commandParams.getServletKey() + "?readReply=false";
        LOG.debug("SendTso::sendDataToTSOCommon - url {}", (Object)url);
        TsoResponseMessage tsoResponseMessage = new TsoResponseMessage("0100", commandParams.getData());
        String jobObjBody = this.getTsoResponseSendMessage(tsoResponseMessage);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, jobObjBody, ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("No results from executing tso command after getting TSO address space. " + errorMsg);
        }
        return UtilTso.getZosmfTsoResponse(response);
    }

    private String getTsoResponseSendMessage(TsoResponseMessage tsoResponseMessage) throws Exception {
        String message = "{\"TSO RESPONSE\":{\"VERSION\":\"" + tsoResponseMessage.getVersion().orElseThrow(() -> new Exception("response version missing")) + "\",\"DATA\":\"" + tsoResponseMessage.getData().orElseThrow(() -> new Exception("response data missing")) + "\"}}";
        LOG.debug("SendTo::getTsoResponseSendMessage - message {}", (Object)message);
        return message;
    }

    private CollectedResponses getAllResponses(ZosmfTsoResponse tso) throws Exception {
        boolean done = false;
        StringBuilder messages = new StringBuilder();
        ArrayList<ZosmfTsoResponse> tsos = new ArrayList<ZosmfTsoResponse>();
        tsos.add(tso);
        while (!done) {
            if (!tso.getTsoData().isEmpty()) {
                for (TsoMessages tsoDatum : tso.getTsoData()) {
                    if (tsoDatum.getTsoMessage().isPresent()) {
                        TsoMessage tsoMsg = tsoDatum.getTsoMessage().get();
                        tsoMsg.getData().ifPresent(data -> {
                            messages.append((String)data);
                            messages.append("\n");
                        });
                        continue;
                    }
                    if (!tsoDatum.getTsoPrompt().isPresent() || messages.length() <= 0) continue;
                    done = true;
                }
            }
            if (done) continue;
            tso = this.getDataFromTSO(tso.getServletKey().orElseThrow(() -> new Exception("servlet key missing")));
            tsos.add(tso);
        }
        return new CollectedResponses(tsos, messages.toString());
    }

    private ZosmfTsoResponse getDataFromTSO(String servletKey) throws Exception {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/tsoApp/tso/" + servletKey;
        LOG.debug("SendTso::getDataFromTSO - url {}", (Object)url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, "", ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("Follow up TSO Messages from TSO command cannot be retrieved. " + errorMsg);
        }
        return UtilTso.getZosmfTsoResponse(response);
    }

    private static SendResponse createResponse(CollectedResponses responses) throws Exception {
        return new SendResponse(true, responses.getTsos(), responses.getMessages().orElseThrow(() -> new Exception("no responses messages exist")));
    }
}

