/*
 * Decompiled with CFR 0.152.
 */
package utility;

import core.ZOSConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import utility.Timer;

public class Util {
    public static void wait(int time) {
        Timer timer = new Timer(time).initialize();
        while (!timer.isEnded()) {
        }
    }

    public static String getAuthEncoding(ZOSConnection connection) {
        Util.checkConnection(connection);
        return Base64.getEncoder().encodeToString((connection.getUser() + ":" + connection.getPassword()).getBytes(StandardCharsets.UTF_8));
    }

    public static void checkConnection(ZOSConnection connection) {
        if (connection == null || connection.getZosmfPort() == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getZosmfPort().isEmpty() || connection.getHost().isEmpty() || connection.getPassword().isEmpty() || connection.getUser().isEmpty()) {
            throw new IllegalStateException("Connection data not setup properly");
        }
    }

    public static void checkNullParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new NullPointerException(message.orElse("empty message specified"));
        }
    }

    public static void checkIllegalParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new IllegalArgumentException(message.orElse("empty message specified"));
        }
    }

    public static String encodeURIComponent(String str) {
        Util.checkNullParameter(str == null, "str is null");
        Util.checkIllegalParameter(str.isEmpty(), "str not specified");
        String result = URLEncoder.encode(str, StandardCharsets.UTF_8).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        return result;
    }
}

