/*
 * Decompiled with CFR 0.152.
 */
package zosjobs;

import core.ZOSConnection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utility.Util;
import zosjobs.GetJobs;
import zosjobs.input.GetJobParams;
import zosjobs.input.JobFile;
import zosjobs.input.MonitorJobWaitForParams;
import zosjobs.response.CheckJobStatus;
import zosjobs.response.Job;
import zosjobs.types.JobStatus;

public class MonitorJobs {
    private static final Logger LOG = LogManager.getLogger(MonitorJobs.class);
    private final ZOSConnection connection;
    private int attempts = 1000;
    private int watchDelay = 3000;
    private int lineLimit = 1000;
    public static final int DEFAULT_LINE_LIMIT = 1000;
    public static final int DEFAULT_WATCH_DELAY = 3000;
    public static final JobStatus.Type DEFAULT_STATUS = JobStatus.Type.OUTPUT;
    public static final int DEFAULT_ATTEMPTS = 1000;

    public MonitorJobs(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public MonitorJobs(ZOSConnection connection, int attempts) {
        Util.checkConnection(connection);
        this.connection = connection;
        this.attempts = attempts;
    }

    public MonitorJobs(ZOSConnection connection, int attempts, int watchDelay) {
        Util.checkConnection(connection);
        this.connection = connection;
        this.attempts = attempts;
        this.watchDelay = watchDelay;
    }

    public MonitorJobs(ZOSConnection connection, int attempts, int watchDelay, int lineLimit) {
        Util.checkConnection(connection);
        this.connection = connection;
        this.attempts = attempts;
        this.watchDelay = watchDelay;
        this.lineLimit = lineLimit;
    }

    public boolean waitForJobMessage(Job job, String message) throws Exception {
        Util.checkNullParameter(job == null, "job is null");
        Util.checkIllegalParameter(job.getJobName().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(job.getJobName().get().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(job.getJobId().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(job.getJobId().get().isEmpty(), "job id not specified");
        return this.waitForMessageCommon(new MonitorJobWaitForParams.Builder(job.getJobName().get(), job.getJobId().get()).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build(), message);
    }

    public boolean waitForJobMessage(String jobName, String jobId, String message) throws Exception {
        return this.waitForMessageCommon(new MonitorJobWaitForParams.Builder(jobName, jobId).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build(), message);
    }

    public boolean waitForMessageCommon(MonitorJobWaitForParams params, String message) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobName().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(params.getJobName().get().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(params.getJobId().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(params.getJobId().get().isEmpty(), "job id not specified");
        if (params.getAttempts().isEmpty()) {
            params.setAttempts(this.attempts);
        }
        if (params.getWatchDelay().isEmpty()) {
            params.setWatchDelay(this.watchDelay);
        }
        if (params.getLineLimit().isEmpty()) {
            params.setLineLimit(this.lineLimit);
        }
        return this.pollForMessage(params, message);
    }

    public Job waitForJobStatus(Job job, JobStatus.Type statusType) throws Exception {
        Util.checkNullParameter(job == null, "job is null");
        Util.checkIllegalParameter(job.getJobName().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(job.getJobName().get().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(job.getJobId().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(job.getJobId().get().isEmpty(), "job id not specified");
        return this.waitForStatusCommon(new MonitorJobWaitForParams.Builder(job.getJobName().get(), job.getJobId().get()).jobStatus(statusType).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitForJobStatus(String jobName, String jobId, JobStatus.Type statusType) throws Exception {
        return this.waitForStatusCommon(new MonitorJobWaitForParams.Builder(jobName, jobId).jobStatus(statusType).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitForJobOutputStatus(Job job) throws Exception {
        Util.checkNullParameter(job == null, "job is null");
        Util.checkIllegalParameter(job.getJobName().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(job.getJobName().get().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(job.getJobId().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(job.getJobId().get().isEmpty(), "job id not specified");
        return this.waitForStatusCommon(new MonitorJobWaitForParams.Builder(job.getJobName().get(), job.getJobId().get()).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitForJobOutputStatus(String jobName, String jobId) throws Exception {
        return this.waitForStatusCommon(new MonitorJobWaitForParams.Builder(jobName, jobId).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitForStatusCommon(MonitorJobWaitForParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobName().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(params.getJobName().get().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(params.getJobId().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(params.getJobId().get().isEmpty(), "job id not specified");
        if (params.getJobStatus().isEmpty()) {
            params.setJobStatus(DEFAULT_STATUS);
        }
        if (params.getAttempts().isEmpty()) {
            params.setAttempts(this.attempts);
        }
        if (params.getWatchDelay().isEmpty()) {
            params.setWatchDelay(this.watchDelay);
        }
        return this.pollForStatus(params);
    }

    public boolean isJobRunning(MonitorJobWaitForParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        GetJobs getJobs = new GetJobs(this.connection);
        String jobName = params.getJobName().orElseThrow(() -> new Exception("job name not specified"));
        String jobId = params.getJobId().orElseThrow(() -> new Exception("job id not specified"));
        String status = getJobs.getStatusValue(jobName, jobId);
        return !JobStatus.Type.OUTPUT.toString().equals(status);
    }

    private boolean checkMessage(MonitorJobWaitForParams params, String message) throws Exception {
        int lineLimit;
        GetJobs getJobs = new GetJobs(this.connection);
        GetJobParams filter = new GetJobParams.Builder("*").jobId(params.getJobId().orElseThrow(() -> new Exception("job id not specified"))).prefix(params.getJobName().orElseThrow(() -> new Exception("job name not specified"))).build();
        List<Job> jobs = getJobs.getJobsCommon(filter);
        if (jobs.isEmpty()) {
            throw new Exception("job does not exist");
        }
        List<JobFile> files = getJobs.getSpoolFilesForJob(jobs.get(0));
        String[] output = getJobs.getSpoolContent(files.get(0)).split("\n");
        int size = output.length;
        int start = size < (lineLimit = params.getLineLimit().orElse(1000)) ? 0 : size - lineLimit;
        for (int i = start; i < size; ++i) {
            LOG.debug(output[i]);
            if (!output[i].contains(message)) continue;
            return true;
        }
        return false;
    }

    private boolean pollForMessage(MonitorJobWaitForParams params, String message) throws Exception {
        boolean shouldContinue;
        int timeoutVal = params.getWatchDelay().orElse(3000);
        int numOfAttempts = 0;
        int maxAttempts = params.getAttempts().orElse(1000);
        LOG.info("Waiting for message \"{}\"", (Object)message);
        do {
            boolean messageFound;
            boolean bl = shouldContinue = !(messageFound = this.checkMessage(params, message)) && maxAttempts > 0 && ++numOfAttempts < maxAttempts;
            if (!shouldContinue) continue;
            Util.wait(timeoutVal);
            if (!this.isJobRunning(params)) {
                return false;
            }
            LOG.info("Waiting for message \"{}\"", (Object)message);
        } while (shouldContinue);
        return numOfAttempts != maxAttempts;
    }

    private Job pollForStatus(MonitorJobWaitForParams params) throws Exception {
        CheckJobStatus checkJobStatus;
        boolean shouldContinue;
        int timeoutVal = params.getWatchDelay().orElse(3000);
        int numOfAttempts = 0;
        int maxAttempts = params.getAttempts().orElse(1000);
        String statusName = params.getJobStatus().orElse(DEFAULT_STATUS).toString();
        LOG.info("Waiting for status \"{}\"", (Object)statusName);
        do {
            boolean expectedStatus;
            boolean bl = shouldContinue = !(expectedStatus = (checkJobStatus = this.checkStatus(params)).isStatusFound()) && maxAttempts > 0 && ++numOfAttempts < maxAttempts;
            if (!shouldContinue) continue;
            Util.wait(timeoutVal);
            LOG.info("Waiting for status \"{}\"", (Object)statusName);
        } while (shouldContinue);
        if (numOfAttempts == maxAttempts) {
            throw new Exception("Desired status not seen. The number of maximum attempts reached.");
        }
        return checkJobStatus.getJob();
    }

    private CheckJobStatus checkStatus(MonitorJobWaitForParams params) throws Exception {
        Job job;
        GetJobs getJobs = new GetJobs(this.connection);
        String statusNameCheck = params.getJobStatus().orElse(DEFAULT_STATUS).toString();
        if (statusNameCheck.equals((job = getJobs.getStatus(params.getJobName().orElseThrow(() -> new Exception("job name not specified")), params.getJobId().orElseThrow(() -> new Exception("job id not specified")))).getStatus().orElse(DEFAULT_STATUS.toString()))) {
            return new CheckJobStatus(true, job);
        }
        String invalidStatusMsg = "Invalid status when checking for status ordering.";
        int orderIndexOfDesiredJobStatus = this.getOrderIndexOfStatus(statusNameCheck);
        if (orderIndexOfDesiredJobStatus == -1) {
            throw new Exception(invalidStatusMsg);
        }
        int orderIndexOfCurrRunningJobStatus = this.getOrderIndexOfStatus(job.getStatus().orElseThrow(() -> new Exception("job status not specified")));
        if (orderIndexOfCurrRunningJobStatus == -1) {
            throw new Exception(invalidStatusMsg);
        }
        if (orderIndexOfCurrRunningJobStatus > orderIndexOfDesiredJobStatus) {
            return new CheckJobStatus(true, job);
        }
        return new CheckJobStatus(false, job);
    }

    private int getOrderIndexOfStatus(String statusName) {
        for (int i = 0; i < JobStatus.Order.length; ++i) {
            if (!statusName.equals(JobStatus.Order[i])) continue;
            return i;
        }
        return -1;
    }
}

