/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import java.util.List;
import java.util.Optional;
import zostso.CollectedResponses;
import zostso.zosmf.TsoMessages;
import zostso.zosmf.ZosmfMessages;
import zostso.zosmf.ZosmfTsoResponse;

public class StartStopResponses {
    private final ZosmfTsoResponse zosmfTsoResponse;
    private List<ZosmfTsoResponse> collectedResponses;
    private final String failureResponse;
    private String servletKey;
    private final String messages;
    private final boolean success;

    public StartStopResponses(ZosmfTsoResponse zosmfTsoResponse, CollectedResponses collectedResponses) throws Exception {
        if (zosmfTsoResponse == null) {
            throw new Exception("zosmfTsoResponse is null");
        }
        this.zosmfTsoResponse = zosmfTsoResponse;
        if (!zosmfTsoResponse.getMsgData().isEmpty()) {
            this.success = false;
            ZosmfMessages zosmfMsg = zosmfTsoResponse.getMsgData().get(0);
            this.failureResponse = zosmfMsg.getMessageText().orElse("zOSMF unknown error response");
        } else {
            this.success = true;
            this.failureResponse = null;
        }
        this.servletKey = zosmfTsoResponse.getServletKey().orElseThrow(() -> new Exception("servletKey is missing"));
        StringBuilder buildMessage = new StringBuilder();
        List<TsoMessages> tsoMsgLst = zosmfTsoResponse.getTsoData();
        tsoMsgLst.forEach(buildMessage::append);
        this.messages = buildMessage.toString();
        this.collectedResponses = collectedResponses.getTsos();
    }

    public Optional<ZosmfTsoResponse> getZosmfTsoResponse() {
        return Optional.of(this.zosmfTsoResponse);
    }

    public List<ZosmfTsoResponse> getCollectedResponses() {
        return this.collectedResponses;
    }

    public void setCollectedResponses(List<ZosmfTsoResponse> collectedResponses) {
        this.collectedResponses = collectedResponses;
    }

    public Optional<String> getFailureResponse() {
        return Optional.of(this.failureResponse);
    }

    public Optional<String> getServletKey() {
        return Optional.ofNullable(this.servletKey);
    }

    public void setServletKey(String servletKey) {
        this.servletKey = servletKey;
    }

    public Optional<String> getMessages() {
        return Optional.of(this.messages);
    }

    public boolean isSuccess() {
        return this.success;
    }
}

