/*
 * Decompiled with CFR 0.152.
 */
package examples.zosconsole;

import core.ZOSConnection;
import examples.ZosConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zosconsole.ConsoleResponse;
import zosconsole.input.IssueParams;
import zosconsole.zosmf.ZosmfIssueParams;
import zosconsole.zosmf.ZosmfIssueResponse;

public class IssueCommand
extends ZosConnection {
    private static final Logger LOG = LogManager.getLogger(IssueCommand.class);

    public static void main(String[] args) {
        String command = "D IPLINFO";
        ZOSConnection connection = new ZOSConnection("XXX", "XXX", "XXX", "XXX");
        IssueCommand.consoleCmdByIssue(connection, command);
        IssueCommand.consoleCmdByIssueSimple(connection, command);
        IssueCommand.consoleCmdByIssueDefConsoleCommon(connection, command);
    }

    public static void consoleCmdByIssue(ZOSConnection connection, String cmd) {
        IssueParams params = new IssueParams();
        params.setCommand(cmd);
        zosconsole.IssueCommand issueCommand = new zosconsole.IssueCommand(connection);
        try {
            ConsoleResponse response = issueCommand.issue(params);
            LOG.info(response.getCommandResponse().orElse(""));
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static void consoleCmdByIssueSimple(ZOSConnection connection, String cmd) {
        zosconsole.IssueCommand issueCommand = new zosconsole.IssueCommand(connection);
        try {
            ConsoleResponse response = issueCommand.issueSimple(cmd);
            LOG.info(response.getCommandResponse().orElse(""));
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static void consoleCmdByIssueDefConsoleCommon(ZOSConnection connection, String cmd) {
        ZosmfIssueParams params = new ZosmfIssueParams();
        params.setCmd(cmd);
        zosconsole.IssueCommand issueCommand = new zosconsole.IssueCommand(connection);
        try {
            ZosmfIssueResponse zResponse = issueCommand.issueDefConsoleCommon(params);
            LOG.info(zResponse.getCmdResponse().orElse(""));
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }
}

