/*
 * Decompiled with CFR 0.152.
 */
package examples.zosfiles;

import core.ZOSConnection;
import examples.ZosConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import zosfiles.ZosDsnCopy;
import zosfiles.input.CopyParams;

public class CopyDataset
extends ZosConnection {
    private static final Logger LOG = LogManager.getLogger(CopyDataset.class);

    public static void main(String[] args) throws Exception {
        String fromDataSetName = "XXX";
        String toDataSetName = "XXX";
        ZOSConnection connection = new ZOSConnection("XXX", "XXX", "XXX", "XXX");
        CopyDataset.copyDataset(connection, fromDataSetName, toDataSetName);
        CopyDataset.copyDatasetByCopyParams(connection, fromDataSetName, toDataSetName);
        fromDataSetName = "XXX";
        toDataSetName = "XXX";
        CopyDataset.copyFullPartitionDatasetByCopyParams(connection, fromDataSetName, toDataSetName);
    }

    public static void copyDataset(ZOSConnection connection, String fromDataSetName, String toDataSetName) throws Exception {
        ZosDsnCopy zosDsnCopy = new ZosDsnCopy(connection);
        Response response = zosDsnCopy.copy(fromDataSetName, toDataSetName, true, false);
        LOG.info("http response code " + response.getStatusCode());
    }

    public static void copyDatasetByCopyParams(ZOSConnection connection, String fromDataSetName, String toDataSetName) throws Exception {
        ZosDsnCopy zosDsnCopy = new ZosDsnCopy(connection);
        CopyParams copyParams = new CopyParams.Builder().fromDataSet(fromDataSetName).toDataSet(toDataSetName).build();
        Response response = zosDsnCopy.copy(copyParams);
        LOG.info("http response code " + response.getStatusCode());
    }

    public static void copyFullPartitionDatasetByCopyParams(ZOSConnection connection, String fromDataSetName, String toDataSetName) throws Exception {
        ZosDsnCopy zosDsnCopy = new ZosDsnCopy(connection);
        CopyParams copyParams = new CopyParams.Builder().fromDataSet(fromDataSetName).toDataSet(toDataSetName).copyAllMembers(true).build();
        Response response = zosDsnCopy.copy(copyParams);
        LOG.info("http response code " + response.getStatusCode());
    }
}

