/*
 * Decompiled with CFR 0.152.
 */
package examples.zosjobs;

import core.ZOSConnection;
import examples.ZosConnection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zosjobs.input.CommonJobParams;
import zosjobs.input.GetJobParams;
import zosjobs.input.JobFile;
import zosjobs.response.Job;

public class GetJobs
extends ZosConnection {
    private static final Logger LOG = LogManager.getLogger(GetJobs.class);
    private static zosjobs.GetJobs getJobs;

    public static void main(String[] args) throws Exception {
        String prefix = "XXX";
        String owner = "XXX";
        String jobId = "XXX";
        ZOSConnection connection = new ZOSConnection("XXX", "XXX", "XXX", "XXX");
        getJobs = new zosjobs.GetJobs(connection);
        GetJobs.getJobsCommon(prefix);
        GetJobs.getSpoolFiles(prefix);
        GetJobs.getSpoolFilesForJob(prefix);
        GetJobs.getJobsByOwner(owner);
        GetJobs.getSpoolContent(prefix);
        GetJobs.getJobs();
        GetJobs.getJobsByPrefix(prefix);
        GetJobs.getJobsByOwnerAndPrefix("*", prefix);
        GetJobs.getJob(prefix);
        GetJobs.nonExistentGetJob(jobId);
        GetJobs.getStatus(prefix);
        GetJobs.getStatusForJob(prefix);
        GetJobs.getJcl(prefix);
        GetJobs.getJclForJob(prefix);
        GetJobs.getJclCommon(prefix);
    }

    public static void getJclCommon(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        LOG.info(getJobs.getJclCommon(new CommonJobParams(jobs.get(0).getJobId().orElseThrow(() -> new Exception("job id not specified")), jobs.get(0).getJobName().orElseThrow(() -> new Exception("job name not specified")))));
    }

    public static void getJclForJob(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        LOG.info(getJobs.getJclForJob(jobs.get(0)));
    }

    public static void getJcl(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        LOG.info(getJobs.getJcl(jobs.get(0).getJobName().orElseThrow(() -> new Exception("job name not specified")), jobs.get(0).getJobId().orElseThrow(() -> new Exception("job id not specified"))));
    }

    public static void getStatusForJob(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        try {
            Job job = getJobs.getStatusForJob(jobs.get(0));
            LOG.info(job);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getStatus(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        try {
            Job job = getJobs.getStatus(jobs.get(0).getJobName().orElseThrow(() -> new Exception("job name not specified")), jobs.get(0).getJobId().orElseThrow(() -> new Exception("job id not specified")));
            LOG.info(job);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void nonExistentGetJob(String jobId) {
        try {
            getJobs.getJob(jobId);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static void getJob(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        String jobId = jobs.get(0).getJobId().orElseThrow(() -> new Exception("job id not specified"));
        try {
            Job job = getJobs.getJob(jobId);
            LOG.info(job);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static void getJobsByOwnerAndPrefix(String owner, String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByOwnerAndPrefix(owner, prefix);
        jobs.forEach(LOG::info);
    }

    public static void getJobsByPrefix(String prefix) throws Exception {
        List<Job> jobs = getJobs.getJobsByPrefix(prefix);
        jobs.forEach(LOG::info);
    }

    public static void getJobs() throws Exception {
        List<Job> jobs = getJobs.getJobs();
        jobs.forEach(LOG::info);
    }

    public static void getSpoolContent(String prefix) throws Exception {
        GetJobParams params = new GetJobParams.Builder("*").prefix(prefix).build();
        List<Job> jobs = getJobs.getJobsCommon(params);
        List<JobFile> files = getJobs.getSpoolFilesForJob(jobs.get(0));
        String[] output = getJobs.getSpoolContent(files.get(0)).split("\n");
        for (int i = output.length - 10; i < output.length; ++i) {
            LOG.info(output[i]);
        }
    }

    public static void getJobsByOwner(String owner) throws Exception {
        List<Job> jobs = getJobs.getJobsByOwner(owner);
        jobs.forEach(LOG::info);
    }

    public static void getSpoolFilesForJob(String prefix) throws Exception {
        GetJobParams params = new GetJobParams.Builder("*").prefix(prefix).build();
        List<Job> jobs = getJobs.getJobsCommon(params);
        List<JobFile> files = getJobs.getSpoolFilesForJob(jobs.get(0));
        files.forEach(LOG::info);
    }

    public static void getSpoolFiles(String prefix) throws Exception {
        GetJobParams params = new GetJobParams.Builder("*").prefix(prefix).build();
        List<Job> jobs = getJobs.getJobsCommon(params);
        List<JobFile> files = getJobs.getSpoolFiles(jobs.get(0).getJobName().orElseThrow(() -> new Exception("job name not specified")), jobs.get(0).getJobId().orElseThrow(() -> new Exception("job id not specified")));
        files.forEach(LOG::info);
    }

    public static void getJobsCommon(String prefix) throws Exception {
        GetJobParams params = new GetJobParams.Builder("*").prefix(prefix).build();
        List<Job> jobs = getJobs.getJobsCommon(params);
        jobs.forEach(LOG::info);
    }
}

