/*
 * Decompiled with CFR 0.152.
 */
package rest;

import core.ZOSConnection;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.methods.HttpDelete;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;

public class JsonDeleteRequest
extends ZoweRequest {
    private static final Logger LOG = LogManager.getLogger(JsonDeleteRequest.class);
    private HttpDelete request;

    public JsonDeleteRequest(ZOSConnection connection, String url) throws Exception {
        super(connection, ZoweRequestType.VerbType.DELETE_JSON);
        if (!UtilRest.isUrlValid(url)) {
            throw new Exception("url is invalid");
        }
        this.request = new HttpDelete(url);
        this.setup();
    }

    @Override
    public Response executeRequest() throws Exception {
        LOG.debug("JsonDeleteRequest::executeRequest");
        return this.executeJsonRequest(this.request);
    }

    @Override
    public void setStandardHeaders() {
        this.request.setHeader("Authorization", "Basic " + Util.getAuthEncoding(this.connection));
        this.request.setHeader("Content-Type", "application/json");
        this.request.setHeader(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        headers.forEach((key, value) -> this.request.setHeader((String)key, (String)value));
    }

    @Override
    public void setRequest(String url) throws Exception {
        this.request = new HttpDelete(Optional.ofNullable(url).orElseThrow(() -> new Exception("url not specified")));
        this.setup();
    }
}

