/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.util.List;
import org.json.simple.JSONObject;
import utility.Util;
import zosfiles.response.Dataset;

public class UtilDataset {
    public static Dataset createDatasetObjFromJson(JSONObject json) {
        return new Dataset.Builder().dsname((String)json.get("dsname")).blksz((String)json.get("blksz")).catnm((String)json.get("catnm")).cdate((String)json.get("cdate")).dev((String)json.get("dev")).dsntp((String)json.get("dsntp")).dsorg((String)json.get("dsorg")).edate((String)json.get("edate")).extx((String)json.get("extx")).lrectl((String)json.get("lrectl")).migr((String)json.get("migr")).mvol((String)json.get("mvol")).ovf((String)json.get("ovf")).rdate((String)json.get("rdate")).recfm((String)json.get("recfm")).sizex((String)json.get("sizex")).spacu((String)json.get("spacu")).used((String)json.get("used")).vol((String)json.get("vol")).build();
    }

    public static void checkHttpErrors(String errMsg, List<String> dsNames, Operation type) throws Exception {
        Util.checkNullParameter(errMsg == null, "errMsg is null");
        Util.checkIllegalParameter(((String)errMsg).isEmpty(), "errMsg not specified");
        Util.checkNullParameter(dsNames == null, "dsNames is null");
        Util.checkIllegalParameter(dsNames.isEmpty(), "dsNames not specified");
        Util.checkNullParameter(type == null, "crudType is null");
        String http404 = "is invalid or non-existent.";
        String http500Pre = "You may not have permission to";
        String http500 = ", the request is invalid,";
        String http500Create = "or the dataset(s) or member already exists.";
        String http500Post = "or the dataset(s) or member does not exist.";
        errMsg = ((String)errMsg).substring(0, ((String)errMsg).length() - 1);
        errMsg = (String)errMsg + " for " + type.toString().toUpperCase() + " request.";
        StringBuilder datasets = new StringBuilder();
        if (((String)errMsg).contains("404")) {
            if (dsNames.size() == 1) {
                throw new Exception(String.format("%s '%s' %s", errMsg, dsNames.get(0), http404));
            }
            datasets.append((String)errMsg);
            UtilDataset.appendAllDS(dsNames, datasets);
            datasets.append(" ");
            datasets.append(http404);
            throw new Exception(datasets.toString());
        }
        if ("create".equals(type.toString())) {
            if (((String)errMsg).contains("500")) {
                String newErrMsg = String.format("%s %s '%s' %s %s", errMsg, http500Pre, dsNames.get(0), http500Create, http500Post);
                throw new Exception(newErrMsg);
            }
            throw new Exception((String)errMsg);
        }
        if ("copy".equals(type.toString())) {
            if (((String)errMsg).contains("500")) {
                if (dsNames.size() == 1) {
                    String newErrMsg = UtilDataset.formatPrePostMsg((String)errMsg, dsNames, http500Pre, http500, http500Post);
                    throw new Exception(newErrMsg);
                }
                datasets.append((String)errMsg);
                datasets.append(" ");
                datasets.append(http500Pre);
                UtilDataset.appendAllDS(dsNames, datasets);
                datasets.append(http500);
                datasets.append(" ");
                datasets.append(http500Post);
                datasets.append(" Check CopyParams copyAllMembers setting.");
                datasets.append(" You may have specified a partition data set but expected a sequential data set.");
                throw new Exception(datasets.toString());
            }
            throw new Exception((String)errMsg);
        }
        if (((String)errMsg).contains("500")) {
            String newErrMsg = UtilDataset.formatPrePostMsg((String)errMsg, dsNames, http500Pre, http500, http500Post);
            throw new Exception(newErrMsg);
        }
        throw new Exception((String)errMsg);
    }

    private static String formatPrePostMsg(String errMsg, List<String> dsNames, String http500Pre, String http500, String http500Post) {
        return String.format("%s %s '%s' %s %s", errMsg, http500Pre, dsNames.get(0), http500, http500Post);
    }

    private static void appendAllDS(List<String> dsNames, StringBuilder datasets) {
        dsNames.forEach(ds -> {
            datasets.append(" '");
            datasets.append((String)ds);
            datasets.append("'");
        });
    }

    public static enum Attribute {
        BASE,
        VOL;

    }

    public static enum Operation {
        create,
        read,
        copy,
        delete,
        write,
        download;

    }
}

