/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import rest.Response;
import utility.Util;

public class UtilRest {
    private static final Logger LOG = LogManager.getLogger(UtilRest.class);

    public static Object getJsonResponseEntity(HttpResponse httpResponse) throws Exception {
        Util.checkNullParameter(httpResponse == null, "httpResponse is null");
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString(entity);
            LOG.debug("UtilRest::getJsonResponseEntity - result = {}", (Object)result);
            JSONParser parser = new JSONParser();
            try {
                if (result.isEmpty()) {
                    return null;
                }
                return parser.parse(result);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object getTextResponseEntity(HttpResponse httpResponse) throws Exception {
        Util.checkNullParameter(httpResponse == null, "httpResponse is null");
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString(entity);
            LOG.debug("UtilRest::getTextResponseEntity - result = {}", (Object)result);
            return result;
        }
        return null;
    }

    public static void checkHttpErrors(Response response) throws Exception {
        Util.checkNullParameter(response == null, "response is null");
        if (!response.getStatusCode().isPresent()) {
            throw new Exception("no http code value returned");
        }
        int httpCode = response.getStatusCode().get();
        if (UtilRest.isHttpError(httpCode)) {
            String responsePhrase = "";
            if (response.getResponsePhrase().isPresent()) {
                responsePhrase = (String)response.getResponsePhrase().get();
            }
            Object errorMsg = "Http error code ";
            errorMsg = !responsePhrase.isEmpty() ? (String)errorMsg + httpCode + " " + responsePhrase + "." : (String)errorMsg + httpCode + ".";
            throw new Exception((String)errorMsg);
        }
    }

    public static boolean isHttpError(int statusCode) {
        return !(statusCode >= 200 && statusCode <= 299 || statusCode >= 100 && statusCode <= 199);
    }

    public static boolean isUrlValid(String url) {
        Util.checkNullParameter(url == null, "url is null");
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return false;
        }
    }
}

