/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import rest.Response;
import utility.Util;
import utility.UtilRest;
import zostso.StartStopResponse;
import zostso.zosmf.TsoMessage;
import zostso.zosmf.TsoMessages;
import zostso.zosmf.TsoPromptMessage;
import zostso.zosmf.ZosmfMessages;
import zostso.zosmf.ZosmfTsoResponse;

public class UtilTso {
    public static StartStopResponse populateStartAndStop(ZosmfTsoResponse zosmfResponse) {
        Util.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        StartStopResponse startStopResponse = new StartStopResponse(false, zosmfResponse, zosmfResponse.getServletKey().orElse(""));
        startStopResponse.setSuccess(zosmfResponse.getServletKey().isPresent());
        if (!zosmfResponse.getMsgData().isEmpty()) {
            ZosmfMessages zosmfMsg = zosmfResponse.getMsgData().get(0);
            String msgText = zosmfMsg.getMessageText().orElse("zOSMF unknown error response");
            startStopResponse.setFailureResponse(msgText);
        }
        return startStopResponse;
    }

    public static ZosmfTsoResponse parseJsonStopResponse(JSONObject obj) {
        Util.checkNullParameter(obj == null, "no obj to parse");
        return new ZosmfTsoResponse.Builder().ver((String)obj.get("ver")).servletKey((String)obj.get("servletKey")).reused((Boolean)obj.get("reused")).timeout((Boolean)obj.get("timeout")).build();
    }

    public static ZosmfTsoResponse getZosmfTsoResponse(Response response) throws Exception {
        ZosmfTsoResponse result;
        Util.checkNullParameter(response == null, "response is null");
        int statusCode = response.getStatusCode().get();
        if (response.getStatusCode().isPresent() && UtilRest.isHttpError(statusCode)) {
            String errorMsg = (String)response.getResponsePhrase().orElseThrow(() -> new Exception("results not available"));
            ZosmfMessages zosmfMsg = new ZosmfMessages(errorMsg, null, null);
            ArrayList<ZosmfMessages> zosmfMessages = new ArrayList<ZosmfMessages>();
            zosmfMessages.add(zosmfMsg);
            result = new ZosmfTsoResponse.Builder().msgData(zosmfMessages).build();
        } else {
            result = UtilTso.parseJsonTsoResponse(response.getResponsePhrase().orElse(null));
        }
        return result;
    }

    private static ZosmfTsoResponse parseJsonTsoResponse(JSONObject result) throws Exception {
        ZosmfTsoResponse response;
        Util.checkNullParameter(result == null, "no results to parse");
        try {
            response = new ZosmfTsoResponse.Builder().queueId((String)result.get("queueID")).ver((String)result.get("ver")).servletKey((String)result.get("servletKey")).reused((Boolean)result.get("reused")).timeout((Boolean)result.get("timeout")).build();
        }
        catch (Exception e) {
            throw new Exception("missing one of the following json field values: queueID, ver, servletKey, reused and timeout");
        }
        ArrayList tsoMessagesLst = new ArrayList();
        Optional<JSONArray> tsoData = Optional.ofNullable((JSONArray)result.get("tsoData"));
        tsoData.ifPresent(data -> {
            data.forEach(item -> {
                JSONObject obj = (JSONObject)item;
                TsoMessages tsoMessages = new TsoMessages();
                UtilTso.parseJsonTsoMessage(tsoMessagesLst, obj, tsoMessages);
                UtilTso.parseJsonTsoPrompt(tsoMessagesLst, obj, tsoMessages);
            });
            response.setTsoData(tsoMessagesLst);
        });
        return response;
    }

    private static void parseJsonTsoMessage(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoMessageMap = (Map)obj.get("TSO MESSAGE");
        if (tsoMessageMap != null) {
            TsoMessage tsoMessage = new TsoMessage();
            tsoMessageMap.forEach((key, value) -> {
                if ("DATA".equals(key)) {
                    tsoMessage.setData((String)value);
                }
                if ("VERSION".equals(key)) {
                    tsoMessage.setVersion((String)value);
                }
            });
            tsoMessages.setTsoMessage(tsoMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    private static void parseJsonTsoPrompt(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoPromptMap = (Map)obj.get("TSO PROMPT");
        if (tsoPromptMap != null) {
            TsoPromptMessage tsoPromptMessage = new TsoPromptMessage();
            tsoPromptMap.forEach((key, value) -> {
                if ("VERSION".equals(key)) {
                    tsoPromptMessage.setVersion((String)value);
                }
                if ("HIDDEN".equals(key)) {
                    tsoPromptMessage.setHidden((String)value);
                }
            });
            tsoMessages.setTsoPrompt(tsoPromptMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }
}

