/*
 * Decompiled with CFR 0.152.
 */
package zosconsole;

import core.ZOSConnection;
import java.util.HashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilConsole;
import utility.UtilRest;
import zosconsole.ConsoleResponse;
import zosconsole.input.IssueParams;
import zosconsole.zosmf.ZosmfIssueParams;
import zosconsole.zosmf.ZosmfIssueResponse;

public class IssueCommand {
    private static final Logger LOG = LogManager.getLogger(IssueCommand.class);
    private final ZOSConnection connection;

    public IssueCommand(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfIssueResponse issueCommon(String consoleName, ZosmfIssueParams commandParams) throws Exception {
        Util.checkNullParameter(consoleName == null, "consoleName is null");
        Util.checkIllegalParameter(consoleName.isEmpty(), "consoleName not specified");
        Util.checkNullParameter(commandParams == null, "commandParams is null");
        Util.checkIllegalParameter(commandParams.getCmd().isEmpty(), "command not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restconsoles/consoles/" + consoleName;
        LOG.debug(url);
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("cmd", commandParams.getCmd().get());
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(jsonRequestBody);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, jsonRequestBody.toString(), ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeRequest();
        if (response.isEmpty()) {
            return new ZosmfIssueResponse();
        }
        UtilRest.checkHttpErrors(response);
        LOG.debug("Response result {}", (Object)response.getResponsePhrase());
        ZosmfIssueResponse zosmfIssueResponse = new ZosmfIssueResponse();
        JSONObject result = (JSONObject)response.getResponsePhrase().orElseThrow(() -> new Exception("response phrase missing"));
        zosmfIssueResponse.setCmdResponseKey((String)result.get("cmd-response-key"));
        zosmfIssueResponse.setCmdResponseUrl((String)result.get("cmd-response-url"));
        zosmfIssueResponse.setCmdResponseUri((String)result.get("cmd-response-uri"));
        zosmfIssueResponse.setCmdResponse((String)result.get("cmd-response"));
        zosmfIssueResponse.setSolKeyDetected((String)result.get("sol-key-detected"));
        return zosmfIssueResponse;
    }

    public ZosmfIssueResponse issueDefConsoleCommon(ZosmfIssueParams commandParams) throws Exception {
        ZosmfIssueResponse resp = this.issueCommon("defcn", commandParams);
        resp.setCmdResponse(StringEscapeUtils.escapeJava(resp.getCmdResponse().orElse("")));
        return resp;
    }

    public ConsoleResponse issue(IssueParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        String consoleName = params.getConsoleName().orElse("defcn");
        ZosmfIssueParams commandParams = this.buildZosmfConsoleApiParameters(params);
        ConsoleResponse response = new ConsoleResponse();
        ZosmfIssueResponse resp = this.issueCommon(consoleName, commandParams);
        UtilConsole.populate(resp, response, params.getProcessResponses().orElse(true));
        return response;
    }

    public ConsoleResponse issueSimple(String theCommand) throws Exception {
        IssueParams params = new IssueParams();
        params.setCommand(theCommand);
        return this.issue(params);
    }

    private ZosmfIssueParams buildZosmfConsoleApiParameters(IssueParams params) {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getCommand().isEmpty(), "command not specified");
        ZosmfIssueParams zosmfParams = new ZosmfIssueParams();
        zosmfParams.setCmd(params.getCommand().get());
        params.getSolicitedKeyword().ifPresent(zosmfParams::setSolKey);
        params.getSysplexSystem().ifPresent(zosmfParams::setSystem);
        return zosmfParams;
    }
}

