/*
 * Decompiled with CFR 0.152.
 */
package zosjobs;

import core.ZOSConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import rest.JsonGetRequest;
import rest.Response;
import rest.TextGetRequest;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilJobs;
import utility.UtilRest;
import zosjobs.input.CommonJobParams;
import zosjobs.input.GetJobParams;
import zosjobs.input.JobFile;
import zosjobs.response.Job;

public class GetJobs {
    private static final Logger LOG = LogManager.getLogger(GetJobs.class);
    private final ZOSConnection connection;
    private ZoweRequest request;
    private String url;

    public GetJobs(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public List<Job> getJobs() throws Exception {
        return this.getJobsCommon(null);
    }

    public List<Job> getJobsByPrefix(String prefix) throws Exception {
        Util.checkNullParameter(prefix == null, "prefix is null");
        Util.checkIllegalParameter(prefix.isEmpty(), "prefix not specified");
        return this.getJobsCommon(new GetJobParams.Builder("*").prefix(prefix).build());
    }

    public List<Job> getJobsByOwner(String owner) throws Exception {
        Util.checkNullParameter(owner == null, "owner is null");
        Util.checkIllegalParameter(owner.isEmpty(), "owner not specified");
        return this.getJobsCommon(new GetJobParams.Builder(owner).build());
    }

    public List<Job> getJobsByOwnerAndPrefix(String owner, String prefix) throws Exception {
        Util.checkNullParameter(owner == null, "owner is null");
        Util.checkIllegalParameter(owner.isEmpty(), "owner not specified");
        Util.checkNullParameter(prefix == null, "prefix is null");
        Util.checkIllegalParameter(prefix.isEmpty(), "prefix not specified");
        return this.getJobsCommon(new GetJobParams.Builder(owner).prefix(prefix).build());
    }

    public Job getJob(String jobId) throws Exception {
        Util.checkNullParameter(jobId == null, "jobId is null");
        Util.checkIllegalParameter(jobId.isEmpty(), "jobId not specified");
        List<Job> jobs = this.getJobsCommon(new GetJobParams.Builder("*").jobId(jobId).build());
        if (jobs.isEmpty()) {
            throw new Exception("Job not found");
        }
        if (jobs.size() > 1) {
            throw new Exception("Expected 1 job returned but received " + jobs.size() + " jobs.");
        }
        return jobs.get(0);
    }

    public List<Job> getJobsCommon(GetJobParams params) throws Exception {
        ArrayList<Job> jobs = new ArrayList<Job>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs?";
        if (params != null) {
            if (params.getOwner().isPresent()) {
                this.url = this.url + "owner=" + params.getOwner().get();
            }
            if (params.getPrefix().isPresent() && !"*".equals(params.getPrefix().get())) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "prefix=" + Util.encodeURIComponent(params.getPrefix().get());
            }
            if (params.getMaxJobs().isPresent() && params.getMaxJobs().getAsInt() != 1000) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "max-jobs=" + params.getMaxJobs().getAsInt();
            }
            if (params.getJobId().isPresent()) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "jobid=" + params.getJobId().get();
            }
        } else {
            this.url = this.url + "owner=" + this.connection.getUser();
        }
        LOG.debug(this.url);
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, this.url, null, ZoweRequestType.VerbType.GET_JSON);
        } else {
            this.request.setRequest(this.url);
        }
        Response response = this.request.executeRequest();
        if (response.isEmpty()) {
            return jobs;
        }
        UtilRest.checkHttpErrors(response);
        JSONArray results = response.getResponsePhrase().orElse(null);
        if (results == null) {
            return jobs;
        }
        results.forEach(item -> {
            JSONObject jobObj = (JSONObject)item;
            jobs.add(UtilJobs.createJobObjFromJson(jobObj));
        });
        return jobs;
    }

    public String getStatusValue(String jobName, String jobId) throws Exception {
        Util.checkNullParameter(jobName == null, "jobName is null");
        Util.checkNullParameter(jobId == null, "jobId is null");
        Job job = this.getStatusCommon(new CommonJobParams(jobId, jobName));
        return job.getStatus().orElseThrow(() -> new Exception("job status is missing"));
    }

    public String getStatusValueForJob(Job job) throws Exception {
        Util.checkNullParameter(job == null, "job is null");
        Job result = this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
        return result.getStatus().orElseThrow(() -> new Exception("job status is missing"));
    }

    public Job getStatus(String jobName, String jobId) throws Exception {
        Util.checkNullParameter(jobName == null, "jobName is null");
        Util.checkNullParameter(jobId == null, "jobId is null");
        return this.getStatusCommon(new CommonJobParams(jobId, jobName));
    }

    public Job getStatusForJob(Job job) throws Exception {
        Util.checkNullParameter(job == null, "job is null");
        return this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
    }

    public Job getStatusCommon(CommonJobParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobId().isEmpty(), "jobId not specified");
        Util.checkIllegalParameter(params.getJobId().get().isEmpty(), "jobId not specified");
        Util.checkIllegalParameter(params.getJobName().isEmpty(), "jobName not specified");
        Util.checkIllegalParameter(params.getJobName().get().isEmpty(), "jobName not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + Util.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get();
        LOG.debug(this.url);
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, this.url, null, ZoweRequestType.VerbType.GET_JSON);
        } else {
            this.request.setRequest(this.url);
        }
        Response response = this.request.executeRequest();
        if (response.isEmpty()) {
            return new Job.Builder().build();
        }
        UtilRest.checkHttpErrors(response);
        JSONObject result = response.getResponsePhrase().orElse(null);
        if (result == null) {
            return new Job.Builder().build();
        }
        return UtilJobs.createJobObjFromJson(result);
    }

    public List<JobFile> getSpoolFiles(String jobName, String jobId) throws Exception {
        return this.getSpoolFilesCommon(new CommonJobParams(jobId, jobName));
    }

    public List<JobFile> getSpoolFilesForJob(Job job) throws Exception {
        return this.getSpoolFilesCommon(new CommonJobParams(job.getJobId().orElseThrow(() -> new Exception("job id not specified")), job.getJobName().orElseThrow(() -> new Exception("job name not specified"))));
    }

    public List<JobFile> getSpoolFilesCommon(CommonJobParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobId().isEmpty(), "jobId not specified");
        Util.checkIllegalParameter(params.getJobId().get().isEmpty(), "jobId not specified");
        Util.checkIllegalParameter(params.getJobName().isEmpty(), "jobName not specified");
        Util.checkIllegalParameter(params.getJobName().get().isEmpty(), "jobName not specified");
        ArrayList<JobFile> files = new ArrayList<JobFile>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + Util.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files";
        LOG.debug(this.url);
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, this.url, null, ZoweRequestType.VerbType.GET_JSON);
        } else {
            this.request.setRequest(this.url);
        }
        Response response = this.request.executeRequest();
        if (response.isEmpty()) {
            return files;
        }
        UtilRest.checkHttpErrors(response);
        JSONArray results = response.getResponsePhrase().orElse(null);
        if (results == null) {
            return files;
        }
        results.forEach(item -> {
            JSONObject fileObj = (JSONObject)item;
            files.add(new JobFile.Builder().jobId((String)fileObj.get("jobid")).jobName((String)fileObj.get("jobname")).recfm((String)fileObj.get("recfm")).byteCount((Long)fileObj.get("byteCount")).recordCount((Long)fileObj.get("recordCount")).jobCorrelator((String)fileObj.get("job-correlator")).classs((String)fileObj.get("class")).id((Long)fileObj.get("id")).ddName((String)fileObj.get("ddname")).recordsUrl((String)fileObj.get("records-url")).lrecl((Long)fileObj.get("lrecl")).subSystem((String)fileObj.get("subsystem")).stepName((String)fileObj.get("stepname")).procStep((String)fileObj.get("procstep")).build());
        });
        return files;
    }

    public String getJcl(String jobName, String jobId) throws Exception {
        return this.getJclCommon(new CommonJobParams(jobId, jobName));
    }

    public String getJclForJob(Job job) throws Exception {
        return this.getJclCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
    }

    public String getJclCommon(CommonJobParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobName().isEmpty(), "jobName not specified");
        Util.checkIllegalParameter(params.getJobName().get().isEmpty(), "jobName not specified");
        Util.checkIllegalParameter(params.getJobId().isEmpty(), "jobId not specified");
        Util.checkIllegalParameter(params.getJobId().get().isEmpty(), "jobId not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + Util.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files/JCL/records";
        LOG.debug(this.url);
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, this.url, null, ZoweRequestType.VerbType.GET_TEXT);
        } else {
            this.request.setRequest(this.url);
        }
        Response response = this.request.executeRequest();
        if (response.isEmpty()) {
            return "";
        }
        UtilRest.checkHttpErrors(response);
        return (String)response.getResponsePhrase().orElse("");
    }

    public String getSpoolContent(JobFile jobFile) throws Exception {
        return this.getSpoolContentCommon(jobFile);
    }

    public String getSpoolContentById(String jobName, String jobId, int spoolId) throws Exception {
        Util.checkNullParameter(jobName == null, "jobName is null");
        Util.checkNullParameter(jobId == null, "jobId is null");
        Util.checkIllegalParameter(spoolId <= 0, "spoolId not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + Util.encodeURIComponent(jobName) + "/" + jobId + "/files/" + spoolId + "/records";
        LOG.debug(this.url);
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, this.url, null, ZoweRequestType.VerbType.GET_TEXT);
        } else {
            this.request.setRequest(this.url);
        }
        Response response = this.request.executeRequest();
        if (response.isEmpty()) {
            return "";
        }
        UtilRest.checkHttpErrors(response);
        return (String)response.getResponsePhrase().orElse("");
    }

    public String getSpoolContentCommon(JobFile jobFile) throws Exception {
        Util.checkNullParameter(jobFile == null, "jobFile is null");
        Util.checkIllegalParameter(jobFile.getJobName().isEmpty(), "jobName not specified");
        Util.checkIllegalParameter(jobFile.getJobId().isEmpty(), "jobId not specified");
        Util.checkIllegalParameter(jobFile.getId().isEmpty(), "id not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + Util.encodeURIComponent(jobFile.getJobName().get()) + "/" + jobFile.getJobId().get() + "/files/" + jobFile.getId().get() + "/records";
        LOG.debug(this.url);
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, this.url, null, ZoweRequestType.VerbType.GET_TEXT);
        } else {
            this.request.setRequest(this.url);
        }
        Response response = this.request.executeRequest();
        if (response.isEmpty()) {
            return "";
        }
        UtilRest.checkHttpErrors(response);
        return (String)response.getResponsePhrase().orElse("");
    }

    public String getUrl() {
        return this.url;
    }
}

