/*
 * Decompiled with CFR 0.152.
 */
package rest;

import core.ZOSConnection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;

public abstract class ZoweRequest {
    private static final Logger LOG = LogManager.getLogger(ZoweRequest.class);
    public static final String X_CSRF_ZOSMF_HEADER_KEY = (String)ZosmfHeaders.HEADERS.get((Object)"X_CSRF_ZOSMF_HEADER").get(0);
    public static final String X_CSRF_ZOSMF_HEADER_VALUE = (String)ZosmfHeaders.HEADERS.get((Object)"X_CSRF_ZOSMF_HEADER").get(1);
    private final ZoweRequestType.VerbType requestType;
    protected final ZOSConnection connection;
    protected HttpClient client;
    protected final HttpContext localContext = new BasicHttpContext();
    protected HttpResponse httpResponse;

    public ZoweRequest(ZOSConnection connection, ZoweRequestType.VerbType requestType) {
        this.connection = connection;
        this.requestType = requestType;
    }

    public abstract Response executeRequest() throws Exception;

    public abstract void setStandardHeaders();

    public abstract void setHeaders(Map<String, String> var1);

    public abstract void setRequest(String var1) throws Exception;

    protected void setup() {
        this.setStandardHeaders();
        try {
            this.client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, TrustAllStrategy.INSTANCE).build()).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> Response executeJsonRequest(T request) throws Exception {
        int statusCode = this.execute(request);
        if (UtilRest.isHttpError(statusCode)) {
            return new Response(this.httpResponse.getStatusLine().getReasonPhrase(), statusCode);
        }
        return new Response(UtilRest.getJsonResponseEntity(this.httpResponse), statusCode);
    }

    protected <T> Response executeTextRequest(T request) throws Exception {
        int statusCode = this.execute(request);
        if (UtilRest.isHttpError(statusCode)) {
            return new Response(this.httpResponse.getStatusLine().getReasonPhrase(), statusCode);
        }
        return new Response(UtilRest.getTextResponseEntity(this.httpResponse), statusCode);
    }

    protected <T> Response executeStreamRequest(T request) throws Exception {
        int statusCode = this.execute(request);
        if (UtilRest.isHttpError(statusCode)) {
            return new Response(this.httpResponse.getStatusLine().getReasonPhrase(), statusCode);
        }
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity != null) {
            return new Response(entity.getContent(), statusCode);
        }
        return new Response(null, statusCode);
    }

    private <T> int execute(T request) throws Exception {
        Util.checkNullParameter(request == null, "request is null");
        Util.checkNullParameter(this.client == null, "client is null");
        this.httpResponse = this.client.execute((HttpUriRequest)request, this.localContext);
        int statusCode = this.httpResponse.getStatusLine().getStatusCode();
        LOG.debug("ZoweRequest::execute - Response statusCode {}, Response {}", (Object)this.httpResponse.getStatusLine().getStatusCode(), (Object)this.httpResponse.toString());
        return statusCode;
    }

    public ZoweRequestType.VerbType requestType() {
        return this.requestType;
    }
}

