/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import zosfiles.input.ListParams;
import zosfiles.response.Dataset;

public class ZosDsnList {
    private static final Logger LOG = LogManager.getLogger(ZosDsnList.class);
    private final ZOSConnection connection;

    public ZosDsnList(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public List<String> listDsnMembers(String dataSetName, ListParams params) throws Exception {
        Response response;
        Util.checkNullParameter(params == null, "params is null");
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<String> members = new ArrayList<String>();
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + Util.encodeURIComponent(dataSetName) + "/member";
        if (params.getPattern().isPresent()) {
            url = url + "?pattern=" + Util.encodeURIComponent(params.getPattern().get());
        }
        if ((response = this.getResponse(params, headers, url)).isEmpty()) {
            return members;
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(dataSetName), UtilDataset.Operation.read);
        }
        JSONObject results = (JSONObject)response.getResponsePhrase().orElse(new JSONObject());
        if (results.isEmpty()) {
            return members;
        }
        JSONArray items = (JSONArray)results.get("items");
        items.forEach(item -> {
            JSONObject datasetObj = (JSONObject)item;
            members.add(datasetObj.get("member").toString());
        });
        return members;
    }

    public List<Dataset> listDsn(String dataSetName, ListParams params) throws Exception {
        Response response;
        Util.checkNullParameter(params == null, "params is null");
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds?";
        url = url + "dslevel=" + Util.encodeURIComponent(dataSetName);
        if (params.getVolume().isPresent()) {
            url = url + "&volser=" + Util.encodeURIComponent(params.getVolume().get());
        }
        if (params.getStart().isPresent()) {
            url = url + "&start=" + params.getStart().get();
        }
        if ((response = this.getResponse(params, headers, url)).isEmpty()) {
            return datasets;
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(dataSetName), UtilDataset.Operation.read);
        }
        JSONObject results = (JSONObject)response.getResponsePhrase().orElse(new JSONObject());
        if (results.isEmpty()) {
            return datasets;
        }
        JSONArray items = (JSONArray)results.get("items");
        items.forEach(item -> {
            JSONObject datasetObj = (JSONObject)item;
            datasets.add(UtilDataset.createDatasetObjFromJson(datasetObj));
        });
        return datasets;
    }

    private Response getResponse(ListParams params, Map<String, String> headers, String url) throws Exception {
        LOG.debug(url);
        this.setHeaders(params, headers);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.GET_JSON);
        request.setHeaders(headers);
        return request.executeRequest();
    }

    private void setHeaders(ListParams params, Map<String, String> headers) {
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, value);
        if (params.getAttribute().isPresent()) {
            UtilDataset.Attribute attribute = params.getAttribute().get();
            if (attribute == UtilDataset.Attribute.BASE) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(1);
            } else if (attribute == UtilDataset.Attribute.VOL) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_VOL").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_VOL").get(1);
            }
            headers.put(key, value);
        }
        if (params.getMaxLength().isPresent()) {
            key = "X-IBM-Max-Items";
            value = params.getMaxLength().get();
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MAX_ITEMS").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(1);
        }
        headers.put(key, value);
        if (params.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = params.getResponseTimeout().get();
            headers.put(key, value);
        }
        if (params.getRecall().isPresent()) {
            switch (params.getRecall().get().toLowerCase(Locale.ROOT)) {
                case "wait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "nowait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "error": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(1);
                    headers.put(key, value);
                }
            }
        }
    }
}

