/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;
import utility.UtilTso;
import zostso.CollectedResponses;
import zostso.SendTso;
import zostso.StartStopResponses;
import zostso.input.StartTsoParams;
import zostso.zosmf.ZosmfTsoResponse;

public class StartTso {
    private static final Logger LOG = LogManager.getLogger(StartTso.class);
    private final ZOSConnection connection;

    public StartTso(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public StartStopResponses start(String accountNumber, StartTsoParams params) throws Exception {
        Util.checkNullParameter(accountNumber == null, "accountNumber is null");
        Util.checkIllegalParameter(accountNumber.isEmpty(), "accountNumber not specified");
        StartTsoParams customParams = params == null ? this.setDefaultAddressSpaceParams(null, Util.encodeURIComponent(accountNumber)) : this.setDefaultAddressSpaceParams(params, Util.encodeURIComponent(accountNumber));
        ZosmfTsoResponse zosmfResponse = this.startCommon(customParams);
        CollectedResponses collectedResponses = null;
        if (zosmfResponse.getServletKey().isPresent()) {
            SendTso sendTso = new SendTso(this.connection);
            collectedResponses = sendTso.getAllResponses(zosmfResponse);
        }
        return new StartStopResponses(zosmfResponse, collectedResponses);
    }

    public ZosmfTsoResponse startCommon(StartTsoParams commandParams) throws Exception {
        Util.checkNullParameter(commandParams == null, "commandParams is null");
        String url = this.getResourcesQuery(commandParams);
        LOG.debug("StartTso::startCommon - url {}", (Object)url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.POST_JSON);
        Response response = request.executeRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("No results from executing tso command while setting up TSO address space. " + errorMsg);
        }
        return UtilTso.getZosmfTsoResponse(response);
    }

    private StartTsoParams setDefaultAddressSpaceParams(StartTsoParams params, String accountNumber) {
        if (params == null) {
            params = new StartTsoParams();
        }
        String proc = params.getLogonProcedure().orElse("IZUFPROC");
        String chset = params.getCharacterSet().orElse("697");
        String cpage = params.getCodePage().orElse("1047");
        String rowNum = params.getRows().orElse("24");
        String cols = params.getColumns().orElse("80");
        String rSize = params.getRegionSize().orElse("4096");
        return new StartTsoParams(proc, chset, cpage, rowNum, cols, accountNumber, rSize);
    }

    private String getResourcesQuery(StartTsoParams params) throws Exception {
        String query = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort();
        query = query + "/zosmf/tsoApp/tso?";
        query = query + "acct=" + params.account.orElseThrow(() -> new Exception("account num not specified")) + "&";
        query = query + "proc=" + params.logonProcedure.orElse("IZUFPROC") + "&";
        query = query + "chset=" + params.characterSet.orElse("697") + "&";
        query = query + "cpage=" + params.codePage.orElse("1047") + "&";
        query = query + "rows=" + params.rows.orElse("24") + "&";
        query = query + "cols=" + params.columns.orElse("80") + "&";
        query = query + "rsize=" + params.regionSize.orElse("4096");
        return query;
    }
}

