/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import kong.unirest.ProgressMonitor;
import kong.unirest.RawResponse;
import kong.unirest.UnirestException;

class MonitoringInputStream
extends InputStream {
    private final InputStream content;
    private final ProgressMonitor downloadMonitor;
    private long totalSize;
    private long byteCount = 0L;
    private String fileName;

    MonitoringInputStream(InputStream content, ProgressMonitor downloadMonitor, Path target, RawResponse rawResponse) {
        this(content, downloadMonitor, target.getFileName().toString(), rawResponse);
    }

    MonitoringInputStream(InputStream content, ProgressMonitor downloadMonitor, String fileName, RawResponse rawResponse) {
        this.content = this.wrap(content, rawResponse);
        this.downloadMonitor = downloadMonitor;
        this.fileName = fileName;
        this.totalSize = this.getBodySize(rawResponse);
    }

    private InputStream wrap(InputStream is, RawResponse rawResponse) {
        try {
            if (is.available() > 0 && "gzip".equalsIgnoreCase(rawResponse.getContentType())) {
                return new GZIPInputStream(is);
            }
            return is;
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
    }

    private Long getBodySize(RawResponse r) {
        String header = r.getHeaders().getFirst("Content-Length");
        if (header != null && header.length() > 0) {
            return Long.valueOf(header);
        }
        return 0L;
    }

    @Override
    public int read() throws IOException {
        int read = this.content.read();
        if (read != -1) {
            this.monitor(1);
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.content.read(b);
        this.monitor(read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.content.read(b, off, len);
        this.monitor(read);
        return read;
    }

    private void monitor(int bytesRead) {
        if (bytesRead > 0) {
            this.byteCount += (long)bytesRead;
        }
        this.downloadMonitor.accept("body", this.fileName, this.byteCount, this.totalSize);
    }

    @Override
    public void close() throws IOException {
        this.content.close();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.content.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.content.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.content.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.content.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.content.reset();
    }
}

