/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParseResponse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.response.DefinedSystem;
import zowe.client.sdk.zosmfinfo.response.ZosmfSystemsResponse;

public final class SystemsParseResponse
implements JsonParseResponse {
    private static JsonParseResponse INSTANCE;
    private JSONObject data;

    private SystemsParseResponse() {
    }

    public static synchronized JsonParseResponse getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemsParseResponse();
        }
        return INSTANCE;
    }

    @Override
    public Object parseResponse() {
        ValidateUtils.checkNullParameter(this.data == null, "each parseResponse call requires data to be reset via setJsonObject first");
        ZosmfSystemsResponse.Builder systemsResponse = new ZosmfSystemsResponse.Builder().numRows((Long)this.data.get("numRows"));
        JSONArray items = (JSONArray)this.data.get("items");
        if (items != null) {
            int size = items.size();
            DefinedSystem[] definedSystems = new DefinedSystem[size];
            for (int i = 0; i < size; ++i) {
                definedSystems[i] = SystemsParseResponse.parseDefinedSystem((JSONObject)items.get(i));
            }
            return systemsResponse.definedSystems(definedSystems).build();
        }
        this.data = null;
        return systemsResponse.build();
    }

    private static DefinedSystem parseDefinedSystem(JSONObject data) {
        return new DefinedSystem.Builder().systemNickName(data.get("systemNickName") != null ? (String)data.get("systemNickName") : null).groupNames(data.get("groupNames") != null ? (String)data.get("groupNames") : null).cpcSerial(data.get("cpcSerial") != null ? (String)data.get("cpcSerial") : null).zosVR(data.get("zosVR") != null ? (String)data.get("zosVR") : null).systemName(data.get("systemName") != null ? (String)data.get("systemName") : null).jesType(data.get("jesType") != null ? (String)data.get("jesType") : null).sysplexName(data.get("sysplexName") != null ? (String)data.get("sysplexName") : null).jesMemberName(data.get("jesMemberName") != null ? (String)data.get("jesMemberName") : null).httpProxyName(data.get("httpProxyName") != null ? (String)data.get("httpProxyName") : null).ftpDestinationName(data.get("ftpDestinationName") != null ? (String)data.get("ftpDestinationName") : null).url(data.get("url") != null ? (String)data.get("url") : null).cpcName(data.get("cpcName") != null ? (String)data.get("cpcName") : null).build();
    }

    @Override
    public JsonParseResponse setJsonObject(JSONObject data) {
        ValidateUtils.checkNullParameter(data == null, "data is null");
        this.data = data;
        return this;
    }
}

