/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonDeleteRequest;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.JsonPostRequest;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.StreamGetRequest;
import zowe.client.sdk.rest.StreamPutRequest;
import zowe.client.sdk.rest.TextGetRequest;
import zowe.client.sdk.rest.TextPutRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.type.ZoweRequestType;

public final class ZoweRequestFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZoweRequestFactory.class);

    private ZoweRequestFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static ZoweRequest buildRequest(ZosConnection connection, ZoweRequestType type) {
        ZoweRequest request;
        LOG.debug(type.name());
        switch (type) {
            case GET_JSON: {
                request = new JsonGetRequest(connection);
                break;
            }
            case PUT_JSON: {
                request = new JsonPutRequest(connection);
                break;
            }
            case POST_JSON: {
                request = new JsonPostRequest(connection);
                break;
            }
            case DELETE_JSON: {
                request = new JsonDeleteRequest(connection);
                break;
            }
            case GET_TEXT: {
                request = new TextGetRequest(connection);
                break;
            }
            case PUT_TEXT: {
                request = new TextPutRequest(connection);
                break;
            }
            case GET_STREAM: {
                request = new StreamGetRequest(connection);
                break;
            }
            case PUT_STREAM: {
                request = new StreamPutRequest(connection);
                break;
            }
            default: {
                throw new IllegalStateException("no valid ZoweRequestType type specified");
            }
        }
        return request;
    }
}

