/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.method;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.input.IssueConsoleParams;
import zowe.client.sdk.zosconsole.response.ConsoleResponse;
import zowe.client.sdk.zosconsole.response.ZosmfIssueResponse;
import zowe.client.sdk.zosconsole.service.ConsoleResponseService;

public class IssueConsole {
    private final ZosConnection connection;
    private ZoweRequest request;

    public IssueConsole(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public IssueConsole(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public ConsoleResponse issueCommand(String command) throws Exception {
        return this.issueCommandCommon("defcn", new IssueConsoleParams(command));
    }

    public ConsoleResponse issueCommand(String command, String consoleName) throws Exception {
        return this.issueCommandCommon(consoleName, new IssueConsoleParams(command));
    }

    public ConsoleResponse issueCommandCommon(String consoleName, IssueConsoleParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(consoleName == null, "consoleName is null");
        ValidateUtils.checkIllegalParameter(consoleName.isBlank(), "consoleName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restconsoles/consoles/" + EncodeUtils.encodeURIComponent(consoleName);
        HashMap<String, String> issueMap = new HashMap<String, String>();
        issueMap.put("cmd", params.getCmd().orElseThrow(() -> new IllegalStateException("issue console params command not specified")));
        params.getSolKey().ifPresent(solKey -> issueMap.put("sol-key", (String)solKey));
        params.getSystem().ifPresent(sys -> issueMap.put("system", (String)sys));
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(issueMap).toString());
        String jsonStr = RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new IllegalStateException("no issue console response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        return ConsoleResponseService.getInstance().buildConsoleResponse((ZosmfIssueResponse)JsonParseResponseFactory.buildParser(ParseType.MVS_CONSOLE).setJsonObject(jsonObject).parseResponse(), params.isProcessResponse());
    }
}

