/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ChangeModeParams;

public class UssChangeMode {
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssChangeMode(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssChangeMode(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response change(String targetPath, ChangeModeParams params) throws Exception {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, String> chamgeModeMap = new HashMap<String, String>();
        chamgeModeMap.put("request", "chmod");
        if (params.isRecursive()) {
            chamgeModeMap.put("recursive", "true");
        }
        params.getLinks().ifPresent(type -> chamgeModeMap.put("links", type.getValue()));
        chamgeModeMap.put("mode", params.getMode().orElseThrow(() -> new IllegalArgumentException("mode not specified")));
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(chamgeModeMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

