/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class UssMove {
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssMove(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssMove(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response move(String fromPath, String targetPath) throws Exception {
        return this.moveCommon(fromPath, targetPath, true);
    }

    public Response move(String fromPath, String targetPath, boolean overwrite) throws Exception {
        return this.moveCommon(fromPath, targetPath, overwrite);
    }

    private Response moveCommon(String fromPath, String targetPath, boolean overwrite) throws Exception {
        ValidateUtils.checkNullParameter(fromPath == null, "fromPath is null");
        ValidateUtils.checkIllegalParameter(fromPath.isBlank(), "fromPath not specified");
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, Object> moveMap = new HashMap<String, Object>();
        moveMap.put("request", "move");
        moveMap.put("from", FileUtils.validatePath(fromPath));
        moveMap.put("overwrite", overwrite);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(moveMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

