/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.utility.timer.WaitUtil;
import zowe.client.sdk.zosjobs.input.CommonJobParams;
import zowe.client.sdk.zosjobs.input.GetJobParams;
import zowe.client.sdk.zosjobs.input.JobFile;
import zowe.client.sdk.zosjobs.input.MonitorJobWaitForParams;
import zowe.client.sdk.zosjobs.methods.JobGet;
import zowe.client.sdk.zosjobs.response.CheckJobStatus;
import zowe.client.sdk.zosjobs.response.Job;
import zowe.client.sdk.zosjobs.types.JobStatus;

public class JobMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JobMonitor.class);
    public static final int DEFAULT_ATTEMPTS = 1000;
    public static final int DEFAULT_LINE_LIMIT = 1000;
    public static final JobStatus.Type DEFAULT_STATUS = JobStatus.Type.OUTPUT;
    public static final int DEFAULT_WATCH_DELAY = 3000;
    private final ZosConnection connection;
    private int attempts = 1000;
    private int watchDelay = 3000;
    private int lineLimit = 1000;

    public JobMonitor(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobMonitor(ZosConnection connection, int attempts) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.attempts = attempts;
    }

    public JobMonitor(ZosConnection connection, int attempts, int watchDelay) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.attempts = attempts;
        this.watchDelay = watchDelay;
    }

    public JobMonitor(ZosConnection connection, int attempts, int watchDelay, int lineLimit) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.attempts = attempts;
        this.watchDelay = watchDelay;
        this.lineLimit = lineLimit;
    }

    private boolean checkMessage(MonitorJobWaitForParams params, String message) throws Exception {
        int lineLimit;
        JobGet getJobs = new JobGet(this.connection);
        GetJobParams filter = new GetJobParams.Builder("*").jobId(params.getJobId().orElse("")).prefix(params.getJobName().orElse("")).build();
        List<Job> jobs = getJobs.getCommon(filter);
        if (jobs.isEmpty()) {
            throw new IllegalStateException("job does not exist");
        }
        List<JobFile> files = getJobs.getSpoolFilesByJob(jobs.get(0));
        String[] output = getJobs.getSpoolContent(files.get(0)).split("\n");
        int size = output.length;
        int start = size < (lineLimit = params.getLineLimit().orElse(1000)) ? 0 : size - lineLimit;
        for (int i = start; i < size; ++i) {
            LOG.debug(output[i]);
            if (!output[i].contains(message)) continue;
            return true;
        }
        return false;
    }

    private CheckJobStatus checkStatus(MonitorJobWaitForParams params) throws Exception {
        return this.checkStatus(params, false);
    }

    private CheckJobStatus checkStatus(MonitorJobWaitForParams params, boolean isStepData) throws Exception {
        Job job;
        JobGet getJobs = new JobGet(this.connection);
        String statusNameCheck = params.getJobStatus().orElse(DEFAULT_STATUS).toString();
        if (statusNameCheck.equals((job = getJobs.getStatusCommon(new CommonJobParams(params.getJobId().orElse(""), params.getJobName().orElse(""), isStepData))).getStatus().orElse(DEFAULT_STATUS.toString()))) {
            return new CheckJobStatus(true, job);
        }
        String invalidStatusMsg = "Invalid status when checking for status ordering.";
        int orderIndexOfDesiredJobStatus = this.getOrderIndexOfStatus(statusNameCheck);
        if (orderIndexOfDesiredJobStatus == -1) {
            throw new IllegalStateException("Invalid status when checking for status ordering.");
        }
        int orderIndexOfCurrRunningJobStatus = this.getOrderIndexOfStatus(job.getStatus().orElseThrow(() -> new IllegalStateException("job status not specified")));
        if (orderIndexOfCurrRunningJobStatus == -1) {
            throw new IllegalStateException("Invalid status when checking for status ordering.");
        }
        if (orderIndexOfCurrRunningJobStatus > orderIndexOfDesiredJobStatus) {
            return new CheckJobStatus(true, job);
        }
        return new CheckJobStatus(false, job);
    }

    private int getOrderIndexOfStatus(String statusName) {
        for (int i = 0; i < JobStatus.Order.length; ++i) {
            if (!statusName.equals(JobStatus.Order[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean isRunning(MonitorJobWaitForParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        JobGet getJobs = new JobGet(this.connection);
        String jobName = params.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified"));
        String jobId = params.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified"));
        String status = getJobs.getStatusValue(jobName, jobId);
        return !JobStatus.Type.INPUT.toString().equals(status) && !JobStatus.Type.OUTPUT.toString().equals(status);
    }

    private boolean pollByMessage(MonitorJobWaitForParams params, String message) throws Exception {
        boolean shouldContinue;
        int timeoutVal = params.getWatchDelay().orElse(3000);
        int numOfAttempts = 0;
        int maxAttempts = params.getAttempts().orElse(1000);
        LOG.info("Waiting for message \"{}\"", (Object)message);
        do {
            boolean messageFound;
            boolean bl = shouldContinue = !(messageFound = this.checkMessage(params, message)) && maxAttempts > 0 && ++numOfAttempts < maxAttempts;
            if (!shouldContinue) continue;
            WaitUtil.wait(timeoutVal);
            if (!this.isRunning(params)) {
                return false;
            }
            LOG.info("Waiting for message \"{}\"", (Object)message);
        } while (shouldContinue);
        return numOfAttempts != maxAttempts;
    }

    private Job pollByStatus(MonitorJobWaitForParams params) throws Exception {
        CheckJobStatus checkJobStatus;
        boolean shouldContinue;
        int timeoutVal = params.getWatchDelay().orElse(3000);
        int numOfAttempts = 0;
        int maxAttempts = params.getAttempts().orElse(1000);
        String statusName = params.getJobStatus().orElse(DEFAULT_STATUS).toString();
        LOG.info("Waiting for status \"{}\"", (Object)statusName);
        do {
            boolean expectedStatus;
            boolean bl = shouldContinue = !(expectedStatus = (checkJobStatus = this.checkStatus(params)).isStatusFound()) && maxAttempts > 0 && ++numOfAttempts < maxAttempts;
            if (shouldContinue) {
                WaitUtil.wait(timeoutVal);
                LOG.info("Waiting for status \"{}\"", (Object)statusName);
                continue;
            }
            try {
                checkJobStatus = this.checkStatus(params, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (shouldContinue);
        if (numOfAttempts == maxAttempts) {
            throw new IllegalStateException("Desired status not seen. The number of maximum attempts reached.");
        }
        return checkJobStatus.getJob();
    }

    public boolean waitByMessage(Job job, String message) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.waitMessageCommon(new MonitorJobWaitForParams.Builder(job.getJobName().orElse(""), job.getJobId().orElse("")).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build(), message);
    }

    public boolean waitByMessage(String jobName, String jobId, String message) throws Exception {
        return this.waitMessageCommon(new MonitorJobWaitForParams.Builder(jobName, jobId).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build(), message);
    }

    public Job waitByOutputStatus(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.waitStatusCommon(new MonitorJobWaitForParams.Builder(job.getJobName().orElse(""), job.getJobId().orElse("")).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitByOutputStatus(String jobName, String jobId) throws Exception {
        return this.waitStatusCommon(new MonitorJobWaitForParams.Builder(jobName, jobId).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitByStatus(Job job, JobStatus.Type statusType) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.waitStatusCommon(new MonitorJobWaitForParams.Builder(job.getJobName().orElse(""), job.getJobId().orElse("")).jobStatus(statusType).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitByStatus(String jobName, String jobId, JobStatus.Type statusType) throws Exception {
        return this.waitStatusCommon(new MonitorJobWaitForParams.Builder(jobName, jobId).jobStatus(statusType).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public boolean waitMessageCommon(MonitorJobWaitForParams params, String message) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobName().isEmpty(), "job name not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().isEmpty(), "job id not specified");
        if (params.getAttempts().isEmpty()) {
            params.setAttempts(this.attempts);
        }
        if (params.getWatchDelay().isEmpty()) {
            params.setWatchDelay(this.watchDelay);
        }
        if (params.getLineLimit().isEmpty()) {
            params.setLineLimit(this.lineLimit);
        }
        return this.pollByMessage(params, message);
    }

    public Job waitStatusCommon(MonitorJobWaitForParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobName().isEmpty(), "job name not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().isEmpty(), "job id not specified");
        if (params.getJobStatus().isEmpty()) {
            params.setJobStatus(DEFAULT_STATUS);
        }
        if (params.getAttempts().isEmpty()) {
            params.setAttempts(this.attempts);
        }
        if (params.getWatchDelay().isEmpty()) {
            params.setWatchDelay(this.watchDelay);
        }
        return this.pollByStatus(params);
    }
}

