/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.input;

import java.util.Optional;
import zowe.client.sdk.zoslogs.types.DirectionType;
import zowe.client.sdk.zoslogs.types.HardCopyType;

public class ZosLogParams {
    private final Optional<String> startTime;
    private final Optional<HardCopyType> hardCopy;
    private final Optional<DirectionType> direction;
    private final Optional<String> timeRange;
    private final boolean processResponses;

    private ZosLogParams(Builder builder) {
        this.startTime = Optional.ofNullable(builder.startTime);
        this.hardCopy = Optional.ofNullable(builder.hardCopy);
        this.direction = Optional.ofNullable(builder.direction);
        this.timeRange = Optional.ofNullable(builder.timeRange);
        this.processResponses = builder.processResponses;
    }

    public Optional<String> getStartTime() {
        return this.startTime;
    }

    public Optional<HardCopyType> getHardCopy() {
        return this.hardCopy;
    }

    public Optional<DirectionType> getDirection() {
        return this.direction;
    }

    public Optional<String> getTimeRange() {
        return this.timeRange;
    }

    public boolean isProcessResponses() {
        return this.processResponses;
    }

    public String toString() {
        return "ZosLogParams{startTime=" + this.startTime + ", hardCopy=" + this.hardCopy + ", direction=" + this.direction + ", timeRange=" + this.timeRange + ", processResponses=" + this.processResponses + "}";
    }

    public static class Builder {
        private String startTime;
        private HardCopyType hardCopy;
        private DirectionType direction;
        private String timeRange;
        private boolean processResponses;

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder hardCopy(HardCopyType hardCopy) {
            this.hardCopy = hardCopy;
            return this;
        }

        public Builder direction(DirectionType direction) {
            this.direction = direction;
            return this;
        }

        public Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public Builder processResponses(boolean processResponses) {
            this.processResponses = processResponses;
            return this;
        }

        public ZosLogParams build() {
            return new ZosLogParams(this);
        }
    }
}

