/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.service;

import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.message.ZosmfMessages;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.StartStopResponse;

public class TsoResponseService {
    private Response tsoCmdResponse;
    private ZosmfTsoResponse zosmfPhraseResponse;

    public TsoResponseService(Response response) {
        ValidateUtils.checkNullParameter(response == null, "response is null");
        this.tsoCmdResponse = response;
    }

    public TsoResponseService(ZosmfTsoResponse zosmfResponse) {
        ValidateUtils.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        this.zosmfPhraseResponse = zosmfResponse;
    }

    public ZosmfTsoResponse getZosmfTsoResponse() throws Exception {
        ZosmfTsoResponse result;
        int statusCode = this.tsoCmdResponse.getStatusCode().orElseThrow(() -> new IllegalStateException("status code not specified"));
        if (RestUtils.isHttpError(statusCode)) {
            String tsoCmdResponsePhrase = (String)this.tsoCmdResponse.getResponsePhrase().orElseThrow(() -> new IllegalStateException("no tsoCmdResponse phrase"));
            ZosmfMessages zosmfMsg = new ZosmfMessages(tsoCmdResponsePhrase, null, null);
            result = new ZosmfTsoResponse.Builder().msgData(List.of(zosmfMsg)).build();
        } else {
            String jsonStr = this.tsoCmdResponse.getResponsePhrase().orElseThrow(() -> new IllegalStateException("no tsoCmdResponse phrase")).toString();
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
            result = (ZosmfTsoResponse)JsonParseResponseFactory.buildParser(ParseType.TSO_CONSOLE).setJsonObject(jsonObject).parseResponse();
        }
        return result;
    }

    public StartStopResponse setStartStopResponse() {
        StartStopResponse startStopResponse = new StartStopResponse(false, this.zosmfPhraseResponse, this.zosmfPhraseResponse.getServletKey().orElse(""));
        startStopResponse.setSuccess(this.zosmfPhraseResponse.getServletKey().isPresent());
        if (!this.zosmfPhraseResponse.getMsgData().isEmpty()) {
            ZosmfMessages zosmfMsg = this.zosmfPhraseResponse.getMsgData().get(0);
            String msgText = zosmfMsg.getMessageText().orElse("zOSMF unknown error response");
            startStopResponse.setFailureResponse(msgText);
        }
        return startStopResponse;
    }
}

