/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.response.ZosmfInfoResponse;
import zowe.client.sdk.zosmfinfo.response.ZosmfPluginInfo;

public final class SystemInfoJsonParse
implements JsonParse {
    private static JsonParse INSTANCE;
    private JSONObject data;

    private SystemInfoJsonParse() {
    }

    public static synchronized JsonParse getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemInfoJsonParse();
        }
        return INSTANCE;
    }

    @Override
    public Object parseResponse() {
        JSONArray plugins;
        ValidateUtils.checkNullParameter(this.data == null, "each parseResponse call requires data to be reset via setJsonObject first");
        ZosmfInfoResponse.Builder zosmfInfoResponse = new ZosmfInfoResponse.Builder().zosVersion(this.data.get("zos_version") != null ? (String)this.data.get("zos_version") : null).zosmfPort(this.data.get("zosmf_port") != null ? (String)this.data.get("zosmf_port") : null).zosmfVersion(this.data.get("zosmf_version") != null ? (String)this.data.get("zosmf_version") : null).zosmfHostName(this.data.get("zosmf_hostname") != null ? (String)this.data.get("zosmf_hostname") : null).zosmfSafRealm(this.data.get("zosmf_saf_realm") != null ? (String)this.data.get("zosmf_saf_realm") : null).apiVersion(this.data.get("api_version") != null ? (String)this.data.get("api_version") : null).zosmfFullVersion(this.data.get("zosmf_full_version") != null ? (String)this.data.get("zosmf_full_version") : null);
        JSONArray jSONArray = plugins = this.data.get("plugins") != null ? (JSONArray)this.data.get("plugins") : null;
        if (plugins != null) {
            int size = plugins.size();
            ZosmfPluginInfo[] zosmfPluginsInfo = new ZosmfPluginInfo[size];
            for (int i = 0; i < size; ++i) {
                zosmfPluginsInfo[i] = SystemInfoJsonParse.parseZosmfPluginInfo((JSONObject)plugins.get(i));
            }
            return zosmfInfoResponse.zosmfPluginsInfo(zosmfPluginsInfo).build();
        }
        this.data = null;
        return zosmfInfoResponse.build();
    }

    private static ZosmfPluginInfo parseZosmfPluginInfo(JSONObject data) {
        return new ZosmfPluginInfo.Builder().pluginVersion(data.get("pluginVersion") != null ? (String)data.get("pluginVersion") : null).pluginDefaultName(data.get("pluginDefaultName") != null ? (String)data.get("pluginDefaultName") : null).pluginStatus(data.get("pluginStatus") != null ? (String)data.get("pluginStatus") : null).build();
    }

    @Override
    public JsonParse setJsonObject(JSONObject data) {
        ValidateUtils.checkNullParameter(data == null, "data is null");
        this.data = data;
        return this;
    }
}

