/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.message.TsoMessage;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.TsoPromptMessage;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;

public final class TsoJsonParse
implements JsonParse {
    private static JsonParse INSTANCE;
    private JSONObject data;

    private TsoJsonParse() {
    }

    public static synchronized JsonParse getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TsoJsonParse();
        }
        return INSTANCE;
    }

    @Override
    public ZosmfTsoResponse parseResponse() {
        ValidateUtils.checkNullParameter(this.data == null, "each parseResponse call requires data to be reset via setJsonObject first");
        ZosmfTsoResponse response = new ZosmfTsoResponse.Builder().queueId(this.data.get("queueID") != null ? (String)this.data.get("queueID") : null).ver(this.data.get("ver") != null ? (String)this.data.get("ver") : null).servletKey(this.data.get("servletKey") != null ? (String)this.data.get("servletKey") : null).reused(this.data.get("reused") != null && (Boolean)this.data.get("reused") != false).timeout(this.data.get("timeout") != null && (Boolean)this.data.get("timeout") != false).build();
        ArrayList tsoMessagesLst = new ArrayList();
        Optional<JSONArray> tsoData = Optional.ofNullable((JSONArray)this.data.get("tsoData"));
        tsoData.ifPresent(data -> {
            data.forEach(item -> {
                JSONObject obj = (JSONObject)item;
                TsoMessages tsoMessages = new TsoMessages();
                TsoJsonParse.parseJsonTsoMessage(tsoMessagesLst, obj, tsoMessages);
                TsoJsonParse.parseJsonTsoPrompt(tsoMessagesLst, obj, tsoMessages);
            });
            response.setTsoData(tsoMessagesLst);
        });
        this.data = null;
        return response;
    }

    private static void parseJsonTsoMessage(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoMessageMap = (Map)obj.get("TSO MESSAGE");
        if (tsoMessageMap != null) {
            TsoMessage tsoMessage = new TsoMessage();
            tsoMessageMap.forEach((key, value) -> {
                if ("DATA".equals(key)) {
                    tsoMessage.setData((String)value);
                }
                if ("VERSION".equals(key)) {
                    tsoMessage.setVersion((String)value);
                }
            });
            tsoMessages.setTsoMessage(tsoMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    private static void parseJsonTsoPrompt(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoPromptMap = (Map)obj.get("TSO PROMPT");
        if (tsoPromptMap != null) {
            TsoPromptMessage tsoPromptMessage = new TsoPromptMessage();
            tsoPromptMap.forEach((key, value) -> {
                if ("VERSION".equals(key)) {
                    tsoPromptMessage.setVersion((String)value);
                }
                if ("HIDDEN".equals(key)) {
                    tsoPromptMessage.setHidden((String)value);
                }
            });
            tsoMessages.setTsoPrompt(tsoPromptMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    @Override
    public JsonParse setJsonObject(JSONObject data) {
        ValidateUtils.checkNullParameter(data == null, "data is null");
        this.data = data;
        return this;
    }
}

