/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zoslogs.response.ZosLogItem;

public final class ZosLogItemJsonParse
implements JsonParse {
    private static JsonParse INSTANCE;
    private boolean isProcessResponse;
    private JSONObject data;

    private ZosLogItemJsonParse() {
    }

    public static synchronized JsonParse getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ZosLogItemJsonParse();
        }
        return INSTANCE;
    }

    @Override
    public ZosLogItem parseResponse() {
        ValidateUtils.checkNullParameter(this.data == null, "each parseResponse call requires data to be reset via setJsonObject first");
        String message = ZosLogItemJsonParse.processMessage(this.data, this.isProcessResponse);
        ZosLogItem zosLogItem = new ZosLogItem.Builder().cart(this.data.get("cart") != null ? (String)this.data.get("cart") : null).color(this.data.get("color") != null ? (String)this.data.get("color") : null).jobName(this.data.get("jobName") != null ? (String)this.data.get("jobName") : null).message(message).messageId(this.data.get("messageId") != null ? (String)this.data.get("messageId") : null).replyId(this.data.get("replyId") != null ? (String)this.data.get("replyId") : null).system(this.data.get("system") != null ? (String)this.data.get("system") : null).type(this.data.get("type") != null ? (String)this.data.get("type") : null).subType(this.data.get("subType") != null ? (String)this.data.get("subType") : null).time(this.data.get("time") != null ? (String)this.data.get("time") : null).timeStamp(this.data.get("timestamp") != null ? (Long)this.data.get("timestamp") : 0L).build();
        this.data = null;
        return zosLogItem;
    }

    private static String processMessage(JSONObject data, boolean isProcessResponse) {
        try {
            String message = (String)data.get("message");
            if (isProcessResponse) {
                if (message.contains("\r")) {
                    message = message.replace('\r', '\n');
                }
                if (message.contains("\n\n")) {
                    message = message.replaceAll("\n\n", "\n");
                }
            }
            return message;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setProcessResponse(boolean processResponse) {
        this.isProcessResponse = processResponse;
    }

    @Override
    public JsonParse setJsonObject(JSONObject data) {
        ValidateUtils.checkNullParameter(data == null, "data is null");
        this.data = data;
        return this;
    }
}

