/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.UnixZfsJsonParse;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ListParams;
import zowe.client.sdk.zosfiles.uss.input.ListZfsParams;
import zowe.client.sdk.zosfiles.uss.response.UnixFile;
import zowe.client.sdk.zosfiles.uss.response.UnixZfs;

public class UssList {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssList(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssList(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public List<UnixFile> fileList(ListParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        StringBuilder url = new StringBuilder("https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs");
        url.append("?path=").append(EncodeUtils.encodeURIComponent(FileUtils.validatePath(params.getPath().orElseThrow(() -> new IllegalArgumentException("path not specified")))));
        params.getGroup().ifPresent(group -> url.append("&group=").append(EncodeUtils.encodeURIComponent(group)));
        params.getUser().ifPresent(user -> url.append("&user=").append(EncodeUtils.encodeURIComponent(user)));
        params.getMtime().ifPresent(mtime -> url.append("&mtime=").append(EncodeUtils.encodeURIComponent(mtime)));
        params.getSize().ifPresent(size -> url.append("&size=").append(size));
        params.getName().ifPresent(name -> url.append("&name=").append(EncodeUtils.encodeURIComponent(name)));
        params.getPerm().ifPresent(perm -> url.append("&perm=").append(EncodeUtils.encodeURIComponent(perm)));
        if (params.getSize().isPresent() && params.getType().isPresent()) {
            url.append("&type=f");
        } else {
            params.getType().ifPresent(type -> url.append("&type=").append(type.getValue()));
        }
        params.getDepth().ifPresent(depth -> url.append("&depth=").append(depth));
        if (params.isFilesys()) {
            url.append("&filesys=all");
        }
        if (params.isSymlinks()) {
            url.append("&symlinks=report");
        }
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url.toString());
        int maxLength = params.getMaxLength().orElse(0);
        if (maxLength > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        Response response = this.request.executeRequest();
        ArrayList<UnixFile> items = new ArrayList<UnixFile>();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(String.valueOf(response.getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned"))));
        JSONArray jsonArray = (JSONArray)jsonObject.get("items");
        if (jsonArray != null) {
            for (Object jsonObj : jsonArray) {
                items.add((UnixFile)JsonParseFactory.buildParser(ParseType.UNIX_FILE).setJsonObject((JSONObject)jsonObj).parseResponse());
            }
        }
        return items;
    }

    public List<UnixZfs> zfsList(ListZfsParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getPath().isEmpty() && params.getFsname().isEmpty(), "no path or fsname specified");
        StringBuilder url = new StringBuilder("https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/mfs");
        params.getPath().ifPresent(path -> url.append("?path=").append(EncodeUtils.encodeURIComponent(FileUtils.validatePath(path))));
        params.getFsname().ifPresent(fsname -> url.append("?fsname=").append(EncodeUtils.encodeURIComponent(fsname)));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url.toString());
        int maxLength = params.getMaxLength().orElse(0);
        if (maxLength > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        Response response = this.request.executeRequest();
        ArrayList<UnixZfs> items = new ArrayList<UnixZfs>();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(String.valueOf(response.getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned"))));
        JSONArray jsonArray = (JSONArray)jsonObject.get("items");
        if (jsonArray != null) {
            for (Object obj : jsonArray) {
                JSONObject jsonObj = (JSONObject)obj;
                StringBuilder modeStr = new StringBuilder();
                try {
                    JSONArray modeLst = (JSONArray)jsonObj.get("mode");
                    int size = modeLst.size();
                    for (int i = 0; i < size; ++i) {
                        if (size - 1 == i) {
                            modeStr.append(modeLst.get(i).toString());
                            continue;
                        }
                        modeStr.append(modeLst.get(i).toString()).append(",");
                    }
                }
                catch (Exception modeLst) {
                    // empty catch block
                }
                UnixZfsJsonParse parse = (UnixZfsJsonParse)JsonParseFactory.buildParser(ParseType.UNIX_ZFS).setJsonObject(jsonObj);
                parse.setModeStr(modeStr.toString());
                items.add(parse.parseResponse());
            }
        }
        return items;
    }
}

