/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.GetTextZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.CommonJobParams;
import zowe.client.sdk.zosjobs.input.GetJobParams;
import zowe.client.sdk.zosjobs.input.JobFile;
import zowe.client.sdk.zosjobs.response.Job;

public class JobGet {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private String url;

    public JobGet(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobGet(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public String getJcl(String jobName, String jobId) throws Exception {
        return this.getJclCommon(new CommonJobParams(jobId, jobName));
    }

    public String getJclByJob(Job job) {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getJclCommon(new CommonJobParams(job.getJobId().orElse(""), job.getJobName().orElse("")));
    }

    public String getJclCommon(CommonJobParams params) {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified"))) + "/" + params.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified")) + "/files/JCL/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job jcl response phrase"));
    }

    public Job getById(String jobId) throws Exception {
        List<Job> jobs = this.getCommon(new GetJobParams.Builder("*").jobId(jobId).build());
        if (jobs.isEmpty()) {
            throw new IllegalStateException("job not found");
        }
        if (jobs.size() > 1) {
            throw new IllegalStateException("expected 1 job returned but received " + jobs.size() + " jobs.");
        }
        return jobs.get(0);
    }

    public List<Job> getAll() throws Exception {
        return this.getCommon(null);
    }

    public List<Job> getByOwner(String owner) throws Exception {
        return this.getCommon(new GetJobParams.Builder(owner).build());
    }

    public List<Job> getByOwnerAndPrefix(String owner, String prefix) throws Exception {
        return this.getCommon(new GetJobParams.Builder(owner).prefix(prefix).build());
    }

    public List<Job> getByPrefix(String prefix) throws Exception {
        return this.getCommon(new GetJobParams.Builder("*").prefix(prefix).build());
    }

    public List<Job> getCommon(GetJobParams params) throws Exception {
        ArrayList<Job> jobs = new ArrayList<Job>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs?";
        if (params != null) {
            if (params.getOwner().isPresent()) {
                this.url = this.url + "owner=" + params.getOwner().get();
            }
            if (params.getPrefix().isPresent() && !"*".equals(params.getPrefix().get())) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "prefix=" + EncodeUtils.encodeURIComponent(params.getPrefix().get());
            }
            if (params.getMaxJobs().isPresent() && params.getMaxJobs().getAsInt() != 1000) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "max-jobs=" + params.getMaxJobs().getAsInt();
            }
            if (params.getJobId().isPresent()) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "jobid=" + params.getJobId().get();
            }
        } else {
            this.url = this.url + "owner=" + this.connection.getUser();
        }
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no get job response phrase")).toString();
        JSONArray results = (JSONArray)new JSONParser().parse(jsonStr);
        for (Object jsonObj : results) {
            jobs.add((Job)JsonParseFactory.buildParser(ParseType.JOB).setJsonObject((JSONObject)jsonObj).parseResponse());
        }
        return jobs;
    }

    public String getSpoolContent(JobFile jobFile) throws Exception {
        return this.getSpoolContentCommon(jobFile);
    }

    public String getSpoolContent(String jobName, String jobId, int spoolId) {
        ValidateUtils.checkIllegalParameter(spoolId <= 0, "spool id not specified");
        CommonJobParams params = new CommonJobParams(jobId, jobName);
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified"))) + "/" + params.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified")) + "/files/" + spoolId + "/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        String spoolErrMsg = "no job spool content response phrase";
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job spool content response phrase"));
    }

    public String getSpoolContentCommon(JobFile jobFile) {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(jobFile.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified"))) + "/" + jobFile.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified")) + "/files/" + jobFile.getId().orElseThrow(() -> new IllegalArgumentException("job file id not specified")) + "/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        String spoolErrMsg = "no job spool file content response phrase";
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job spool file content response phrase"));
    }

    public List<JobFile> getSpoolFiles(String jobName, String jobId) throws Exception {
        return this.getSpoolFilesCommon(new CommonJobParams(jobId, jobName));
    }

    public List<JobFile> getSpoolFilesCommon(CommonJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified"))) + "/" + params.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified")) + "/files";
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        ArrayList<JobFile> files = new ArrayList<JobFile>();
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElse("").toString();
        if (jsonStr.isBlank()) {
            return files;
        }
        JSONArray results = (JSONArray)new JSONParser().parse(jsonStr);
        for (Object obj : results) {
            JSONObject jsonObj = (JSONObject)obj;
            files.add((JobFile)JsonParseFactory.buildParser(ParseType.JOB_FILE).setJsonObject(jsonObj).parseResponse());
        }
        return files;
    }

    public List<JobFile> getSpoolFilesByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getSpoolFilesCommon(new CommonJobParams(job.getJobId().orElse(""), job.getJobName().orElse("")));
    }

    public Job getStatus(String jobName, String jobId) throws Exception {
        return this.getStatusCommon(new CommonJobParams(jobId, jobName, true));
    }

    public Job getStatusCommon(CommonJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified"))) + "/" + params.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified"));
        if (params.isStepData()) {
            this.url = this.url + "?step-data=Y";
        }
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job get response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        return (Job)JsonParseFactory.buildParser(ParseType.JOB).setJsonObject(jsonObject).parseResponse();
    }

    public Job getStatusByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(""), job.getJobName().orElse(""), true));
    }

    public String getStatusValue(String jobName, String jobId) throws Exception {
        Job job = this.getStatusCommon(new CommonJobParams(jobId, jobName));
        return job.getStatus().orElseThrow(() -> new IllegalStateException("job status not returned"));
    }

    public String getStatusValueByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        Job result = this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(""), job.getJobName().orElse("")));
        return result.getStatus().orElseThrow(() -> new IllegalStateException("job status not returned"));
    }

    public String getUrl() {
        return this.url;
    }
}

