/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.PutTextZosmfRequest;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.SubmitJclParams;
import zowe.client.sdk.zosjobs.input.SubmitJobParams;
import zowe.client.sdk.zosjobs.response.Job;

public class JobSubmit {
    private static final Logger LOG = LoggerFactory.getLogger(JobSubmit.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public JobSubmit(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobSubmit(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public Job submitByJcl(String jcl, String internalReaderRecfm, String internalReaderLrecl) throws Exception {
        return this.submitJclCommon(new SubmitJclParams(jcl, internalReaderRecfm, internalReaderLrecl));
    }

    public Job submitJclCommon(SubmitJclParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        HashMap<String, String> headers = new HashMap<String, String>();
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(1);
        headers.put(key, value);
        if (params.getInternalReaderLrecl().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL").get(0);
            headers.put(key, params.getInternalReaderLrecl().get());
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(1);
            headers.put(key, value);
        }
        if (params.getInternalReaderRecfm().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM").get(0);
            headers.put(key, params.getInternalReaderLrecl().get());
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(1);
            headers.put(key, value);
        }
        if (params.getJclSymbols().isPresent()) {
            headers.putAll(this.getSubstitutionHeaders(params.getJclSymbols().get()));
        }
        key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(0);
        value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(1);
        headers.put(key, value);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs";
        if (this.request == null || !(this.request instanceof PutTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_TEXT);
        }
        this.request.setUrl(url);
        this.request.setBody(params.getJcl().orElseThrow(() -> new IllegalArgumentException("jcl not specified")));
        this.request.setHeaders(headers);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job jcl submit response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        return (Job)JsonParseFactory.buildParser(ParseType.JOB).setJsonObject(jsonObject).parseResponse();
    }

    public Job submit(String jobDataSet) throws Exception {
        return this.submitCommon(new SubmitJobParams(jobDataSet));
    }

    public Job submitCommon(SubmitJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs";
        String fullyQualifiedDataset = "//'" + EncodeUtils.encodeURIComponent(params.getJobDataSet().orElseThrow(() -> new IllegalArgumentException("jobDataSet not specified"))) + "'";
        HashMap<String, CallSite> submitMap = new HashMap<String, CallSite>();
        submitMap.put("file", (CallSite)((Object)fullyQualifiedDataset));
        if (this.request == null || !(this.request instanceof PutJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(submitMap).toString());
        if (params.getJclSymbols().isPresent()) {
            this.request.setHeaders(this.getSubstitutionHeaders(params.getJclSymbols().get()));
        }
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job submit response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        return (Job)JsonParseFactory.buildParser(ParseType.JOB).setJsonObject(jsonObject).parseResponse();
    }

    private Map<String, String> getSubstitutionHeaders(Map<String, String> keyValues) {
        HashMap<String, String> symbolMap = new HashMap<String, String>();
        for (String string : keyValues.values()) {
            if (string.chars().filter(ch -> ch == 34).count() % 2L != 0L) {
                throw new IllegalStateException("Encountered invalid key/value pair. Mismatched quotes.");
            }
            if (!string.isEmpty()) continue;
            throw new IllegalStateException("Encountered invalid key/value pair. Must define a value for key/value pair.");
        }
        for (String string : keyValues.keySet()) {
            String value = keyValues.get(string);
            if (string.isEmpty()) {
                throw new IllegalStateException("Encountered invalid key/value pair. Must define a key for key/value pair.");
            }
            if (string.length() > 8) {
                throw new IllegalStateException("Encountered invalid key/value pair. Key must be 8 characters or less.");
            }
            String string2 = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JCL_SYMBOL_PARTIAL").get(0) + string;
            LOG.debug("JCL symbol header: {}:{}", (Object)string2, (Object)value);
            symbolMap.put(string2, value);
        }
        return symbolMap;
    }
}

