/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.methods;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.response.ZosmfSystemsResponse;

public class ZosmfSystems {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfSystems(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfSystems(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfSystemsResponse get() throws Exception {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/resttopology/systems";
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no z/osmf info response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        return (ZosmfSystemsResponse)JsonParseFactory.buildParser(ParseType.ZOSMF_SYSTEMS).setJsonObject(jsonObject).parseResponse();
    }
}

