/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kong.unirest.BaseRequest;
import kong.unirest.Body;
import kong.unirest.BodyPart;
import kong.unirest.ByteArrayPart;
import kong.unirest.ContentType;
import kong.unirest.FilePart;
import kong.unirest.HttpRequestBody;
import kong.unirest.InputStreamPart;
import kong.unirest.MultipartBody;
import kong.unirest.MultipartMode;
import kong.unirest.ParamPart;
import kong.unirest.ProgressMonitor;
import kong.unirest.Util;

class HttpRequestMultiPart
extends BaseRequest<MultipartBody>
implements MultipartBody {
    private List<BodyPart> parameters = new ArrayList<BodyPart>();
    private MultipartMode mode = MultipartMode.BROWSER_COMPATIBLE;
    private Charset charSet;
    private boolean forceMulti = false;
    private ProgressMonitor monitor;

    HttpRequestMultiPart(HttpRequestBody httpRequest) {
        super(httpRequest);
        this.charSet = httpRequest.getCharset();
    }

    @Override
    public MultipartBody field(String name, String value) {
        this.addPart(new ParamPart(name, value));
        return this;
    }

    @Override
    public MultipartBody field(String name, String value, String contentType) {
        this.addPart(name, value, contentType);
        return this;
    }

    @Override
    public MultipartBody field(String name, Collection<?> collection) {
        for (Object current : collection) {
            this.addPart(name, current, null);
        }
        return this;
    }

    @Override
    public MultipartBody field(String name, InputStream value, ContentType contentType) {
        this.addPart(new InputStreamPart(name, value, contentType.toString()));
        return this;
    }

    @Override
    public MultipartBody field(String name, File file) {
        this.addPart(new FilePart(file, name));
        return this;
    }

    @Override
    public MultipartBody field(String name, File file, String contentType) {
        this.addPart(new FilePart(file, name, contentType));
        return this;
    }

    @Override
    public MultipartBody field(String name, InputStream stream, ContentType contentType, String fileName) {
        this.addPart(new InputStreamPart(name, stream, contentType.toString(), fileName));
        return this;
    }

    @Override
    public MultipartBody field(String name, InputStream stream, String fileName) {
        this.addPart(new InputStreamPart(name, stream, ContentType.APPLICATION_OCTET_STREAM.toString(), fileName));
        return this;
    }

    @Override
    public MultipartBody field(String name, byte[] bytes, ContentType contentType, String fileName) {
        this.addPart(new ByteArrayPart(name, bytes, contentType, fileName));
        return this;
    }

    @Override
    public MultipartBody field(String name, byte[] bytes, String fileName) {
        this.addPart(new ByteArrayPart(name, bytes, ContentType.APPLICATION_OCTET_STREAM, fileName));
        return this;
    }

    @Override
    public MultipartBody charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public MultipartBody contentType(String mimeType) {
        this.header("Content-Type", mimeType);
        return this;
    }

    @Override
    public MultipartBody mode(MultipartMode value) {
        this.mode = value;
        return this;
    }

    @Override
    public MultipartBody uploadMonitor(ProgressMonitor uploadMonitor) {
        this.monitor = uploadMonitor;
        return this;
    }

    @Override
    public Charset getCharset() {
        return this.charSet;
    }

    public MultipartBody fields(Map<String, Object> fields) {
        if (fields != null) {
            for (Map.Entry<String, Object> param : fields.entrySet()) {
                if (param.getValue() instanceof File) {
                    this.field(param.getKey(), (File)param.getValue());
                    continue;
                }
                this.field(param.getKey(), Util.nullToEmpty(param.getValue()));
            }
        }
        return this;
    }

    public MultipartBody field(String name, Object value, String contentType) {
        this.addPart(name, value, contentType);
        return this;
    }

    private void addPart(String name, Object value, String contentType) {
        if (value instanceof InputStream) {
            this.addPart(new InputStreamPart(name, (InputStream)value, contentType));
        } else if (value instanceof File) {
            this.addPart(new FilePart((File)value, name, contentType));
        } else {
            this.addPart(new ParamPart(name, Util.nullToEmpty(value), contentType));
        }
    }

    private void addPart(BodyPart value) {
        this.parameters.add(value);
        Collections.sort(this.parameters);
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.of(this);
    }

    @Override
    public boolean isMultiPart() {
        return this.forceMulti || this.multiParts().stream().anyMatch(BodyPart::isFile);
    }

    @Override
    public boolean isEntityBody() {
        return false;
    }

    @Override
    public Collection<BodyPart> multiParts() {
        return new ArrayList<BodyPart>(this.parameters);
    }

    @Override
    public MultipartMode getMode() {
        return this.mode;
    }

    @Override
    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    MultipartBody forceMultiPart(boolean value) {
        this.forceMulti = value;
        this.headers.remove("Content-Type");
        return this;
    }
}

