/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import java.util.HashMap;
import java.util.Map;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public abstract class ZoweRequest {
    public static final String X_CSRF_ZOSMF_HEADER_KEY = (String)ZosmfHeaders.HEADERS.get((Object)"X_CSRF_ZOSMF_HEADER").get(0);
    public static final String X_CSRF_ZOSMF_HEADER_VALUE = (String)ZosmfHeaders.HEADERS.get((Object)"X_CSRF_ZOSMF_HEADER").get(1);
    protected final ZosConnection connection;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected String url;

    public ZoweRequest(ZosConnection connection) {
        this.connection = connection;
        this.setup();
    }

    protected static Response getJsonResponse(HttpResponse<JsonNode> reply) {
        if (reply.getBody().isArray()) {
            return new Response(reply.getBody().getArray(), reply.getStatus(), reply.getStatusText());
        }
        return new Response(reply.getBody().getObject(), reply.getStatus(), reply.getStatusText());
    }

    private void setup() {
        Unirest.config().verifySsl(false);
        this.setStandardHeaders();
    }

    public abstract Response executeRequest() throws UnirestException;

    public abstract void setBody(Object var1) throws UnirestException;

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.setStandardHeaders();
        this.headers.putAll(headers);
    }

    public abstract void setStandardHeaders();

    public void setUrl(String url) throws IllegalArgumentException {
        ValidateUtils.checkNullParameter(url == null, "url is null");
        ValidateUtils.checkIllegalParameter(url.isEmpty(), "url not specified");
        if (RestUtils.isUrlNotValid(url)) {
            throw new IllegalArgumentException("url is invalid");
        }
        this.url = url;
    }
}

