/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.teamconfig.keytar;

import com.starxg.keytar.Keytar;
import com.starxg.keytar.KeytarException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.teamconfig.keytar.IKeyTar;
import zowe.client.sdk.teamconfig.keytar.KeyTarConfig;
import zowe.client.sdk.utility.ValidateUtils;

public class KeyTarImpl
implements IKeyTar {
    private static final Logger LOG = LoggerFactory.getLogger(KeyTarImpl.class);
    private final List<KeyTarConfig> keyTarConfigs = new ArrayList<KeyTarConfig>();
    private String serviceName;
    private String accountName;
    private String keyString;

    @Override
    public List<KeyTarConfig> getKeyConfigs() throws Exception {
        ValidateUtils.checkNullParameter(this.keyString == null, "keyString is null, perform processKey first");
        ValidateUtils.checkIllegalParameter(this.keyString.isEmpty(), "keyString is empty");
        if (!this.keyTarConfigs.isEmpty()) {
            return this.keyTarConfigs;
        }
        return this.parseJson();
    }

    @Override
    public String getKeyTarValue() {
        ValidateUtils.checkNullParameter(this.keyString == null, "keyString is null, perform processKey first");
        ValidateUtils.checkIllegalParameter(this.keyString.isEmpty(), "keyString is empty");
        return this.keyString;
    }

    private List<KeyTarConfig> parseJson() throws ParseException {
        JSONObject jsonKeyTar = (JSONObject)new JSONParser().parse(this.keyString);
        Set keyTarKeys = jsonKeyTar.keySet();
        for (String keyVal : keyTarKeys) {
            JSONObject jsonVal = (JSONObject)jsonKeyTar.get(keyVal);
            this.keyTarConfigs.add(new KeyTarConfig(keyVal, (String)jsonVal.get("profiles.base.properties.user"), (String)jsonVal.get("profiles.base.properties.password")));
        }
        return this.keyTarConfigs;
    }

    @Override
    public void processKey() throws KeytarException {
        ValidateUtils.checkNullParameter(this.serviceName == null, "serviceName is null");
        ValidateUtils.checkIllegalParameter(this.serviceName.isEmpty(), "serviceName is empty");
        ValidateUtils.checkNullParameter(this.accountName == null, "accountName is null");
        ValidateUtils.checkIllegalParameter(this.accountName.isEmpty(), "accountName is empty");
        Keytar instance = Keytar.getInstance();
        String encodedString = instance.getPassword(this.serviceName, this.accountName);
        LOG.debug("KeyTar encodedString retrieved {}", (Object)encodedString);
        if (encodedString == null) {
            throw new NullPointerException("Unknown service name or account name");
        }
        byte[] decodedBytes = Base64.getDecoder().decode(encodedString);
        this.keyString = new String(decodedBytes);
    }

    @Override
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

