/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import org.json.simple.JSONObject;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.response.ConsoleResponse;
import zowe.client.sdk.zosconsole.response.ZosmfIssueResponse;

public final class ConsoleUtils {
    private ConsoleUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ZosmfIssueResponse parseJsonIssueCmdResponse(JSONObject jsonObject) {
        ZosmfIssueResponse zosmfIssueResponse = new ZosmfIssueResponse();
        zosmfIssueResponse.setCmdResponseKey((String)jsonObject.get("cmd-response-key"));
        zosmfIssueResponse.setCmdResponseUrl((String)jsonObject.get("cmd-response-url"));
        zosmfIssueResponse.setCmdResponseUri((String)jsonObject.get("cmd-response-uri"));
        zosmfIssueResponse.setCmdResponse((String)jsonObject.get("cmd-response"));
        zosmfIssueResponse.setSolKeyDetected((String)jsonObject.get("sol-key-detected"));
        return zosmfIssueResponse;
    }

    public static void populate(ZosmfIssueResponse zosmfResponse, ConsoleResponse response, boolean processResponses) {
        ValidateUtils.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        ValidateUtils.checkNullParameter(response == null, "response is null");
        response.setZosmfResponse(zosmfResponse);
        response.setSuccess(true);
        if (zosmfResponse.getSolKeyDetected().isPresent()) {
            response.setKeywordDetected(true);
        }
        if (zosmfResponse.getCmdResponse().isPresent() && zosmfResponse.getCmdResponse().get().length() > 0 && processResponses) {
            String responseValue = zosmfResponse.getCmdResponse().get().replace('\r', '\n');
            response.setCommandResponse(responseValue);
            if (responseValue.length() > 0 && responseValue.indexOf("\n") != responseValue.length() - 1) {
                response.setCommandResponse(responseValue + "\n");
            }
        }
        zosmfResponse.getCmdResponseKey().ifPresent(response::setLastResponseKey);
        zosmfResponse.getCmdResponseUrl().ifPresent(response::setCmdResponseUrl);
    }
}

