/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.CopyParams;

public class DsnCopy {
    private static final Logger LOG = LoggerFactory.getLogger(DsnCopy.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public DsnCopy(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnCopy(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
        this.request = request;
    }

    private String buildBody(CopyParams params) throws Exception {
        String fromDataSetName = params.getFromDataSet().orElseThrow(() -> new Exception("dataset not specified"));
        boolean isFullPartitionCopy = params.isCopyAllMembers();
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("request", "copy");
        String member = "";
        int startMemberIndex = fromDataSetName.indexOf("(");
        if (startMemberIndex > 0) {
            member = fromDataSetName.substring(startMemberIndex + 1, fromDataSetName.length() - 1);
            fromDataSetName = fromDataSetName.substring(0, startMemberIndex);
        }
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", fromDataSetName);
        if (member.length() > 0) {
            fromDataSetReq.put("member", member);
        } else if (isFullPartitionCopy) {
            fromDataSetReq.put("member", "*");
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        jsonMap.put("from-dataset", fromDataSetObj);
        jsonMap.put("replace", params.isReplace());
        if (params.getFromVolser().isPresent()) {
            jsonMap.put("volser", params.getFromVolser().get());
        }
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(String.valueOf(jsonRequestBody));
        return jsonRequestBody.toString();
    }

    public Response copy(String fromDataSetName, String toDataSetName, boolean replace, boolean copyAllMembers) throws Exception {
        return this.copy(new CopyParams.Builder().fromDataSet(fromDataSetName).toDataSet(toDataSetName).replace(replace).copyAllMembers(copyAllMembers).build());
    }

    public Response copy(CopyParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getFromDataSet().isEmpty(), "fromDataSetName not specified");
        ValidateUtils.checkIllegalParameter(params.getToDataSet().isEmpty(), "toDataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/";
        if (params.getToVolser().isPresent()) {
            url = url + "-(" + params.getToVolser().get() + ")/";
        }
        String toDataSet = params.getToDataSet().get();
        url = url + EncodeUtils.encodeURIComponent(toDataSet);
        LOG.debug(url);
        String body = this.buildBody(params);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(body);
        return RestUtils.getResponse(this.request);
    }
}

