/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonDeleteRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnDelete {
    private static final Logger LOG = LoggerFactory.getLogger(DsnDelete.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public DsnDelete(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnDelete(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public Response delete(String dataSetName, String memberName) throws Exception {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        ValidateUtils.checkNullParameter(memberName == null, "memberName is null");
        ValidateUtils.checkIllegalParameter(memberName.isEmpty(), "memberName not specified");
        return this.delete(String.format("%s(%s)", dataSetName, memberName));
    }

    public Response delete(String dataSetName) throws Exception {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName);
        LOG.debug(url);
        if (this.request == null || !(this.request instanceof JsonDeleteRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        return RestUtils.getResponse(this.request);
    }
}

