/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnRename {
    private static final Logger LOG = LoggerFactory.getLogger(DsnRename.class);
    private final ZosConnection connection;
    private ZoweRequest request;
    private String url;

    public DsnRename(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnRename(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    private String buildBody(String ... args) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("request", "rename");
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", args[0]);
        if (args.length > 1) {
            fromDataSetReq.put("member", args[1]);
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        jsonMap.put("from-dataset", fromDataSetObj);
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(String.valueOf(jsonRequestBody));
        return jsonRequestBody.toString();
    }

    public Response dataSetName(String source, String destination) throws Exception {
        this.setUrl(destination);
        return this.executeRequest(this.buildBody(source));
    }

    private Response executeRequest(String body) throws Exception {
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(this.url);
        this.request.setBody(body);
        return RestUtils.getResponse(this.request);
    }

    public Response memberName(String dsName, String source, String destination) throws Exception {
        this.setUrl(dsName, destination);
        return this.executeRequest(this.buildBody(dsName, source));
    }

    private void setUrl(String ... args) {
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(args[0]);
        if (args.length > 1) {
            this.url = this.url + "(" + EncodeUtils.encodeURIComponent(args[1]) + ")";
        }
    }
}

