/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.zosfiles.uss.types.MountActionType;
import zowe.client.sdk.zosfiles.uss.types.MountModeType;

public class MountParams {
    private final Optional<MountActionType> action;
    private final Optional<String> mountPoint;
    private final Optional<String> fsType;
    private final Optional<MountModeType> mode;

    public MountParams(Builder builder) {
        this.action = Optional.ofNullable(builder.action);
        this.mountPoint = Optional.ofNullable(builder.mountPoint);
        this.fsType = Optional.ofNullable(builder.fsType);
        this.mode = Optional.ofNullable(builder.mode);
    }

    public Optional<MountActionType> getAction() {
        return this.action;
    }

    public Optional<String> getMountPoint() {
        return this.mountPoint;
    }

    public Optional<String> getFsType() {
        return this.fsType;
    }

    public Optional<MountModeType> getMode() {
        return this.mode;
    }

    public String toString() {
        return "MountParams{action=" + this.action + ", mountPoint=" + this.mountPoint + ", fsType=" + this.fsType + ", mode=" + this.mode + "}";
    }

    public static class Builder {
        private MountActionType action;
        private String mountPoint;
        private String fsType;
        private MountModeType mode;

        public MountParams build() {
            return new MountParams(this);
        }

        public Builder action(MountActionType action) {
            this.action = action;
            return this;
        }

        public Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public Builder fsType(String fsType) {
            this.fsType = fsType;
            return this;
        }

        public Builder mode(MountModeType mode) {
            this.mode = mode;
            return this;
        }
    }
}

