/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPostRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.CreateParams;

public class UssCreate {
    private static final Logger LOG = LoggerFactory.getLogger(UssCreate.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssCreate(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssCreate(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    private static String buildBody(CreateParams params) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("type", params.getType().getValue());
        jsonMap.put("mode", params.getMode());
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(String.valueOf(jsonRequestBody));
        return jsonRequestBody.toString();
    }

    public Response create(String name, CreateParams params) throws Exception {
        ValidateUtils.checkNullParameter(name == null, "name is null");
        ValidateUtils.checkIllegalParameter(name.isEmpty(), "name not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(params.getType() == null, "params type is null");
        ValidateUtils.checkNullParameter(params.getMode() == null, "params mode is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + name;
        LOG.debug(url);
        String body = UssCreate.buildBody(params);
        if (this.request == null || !(this.request instanceof JsonPostRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(body);
        return RestUtils.getResponse(this.request);
    }
}

