/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonDeleteRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class UssDelete {
    private static final Logger LOG = LoggerFactory.getLogger(UssDelete.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssDelete(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssDelete(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public Response delete(String name) throws Exception {
        return this.deleteCommon(name, false);
    }

    public Response delete(String name, boolean recursive) throws Exception {
        return this.deleteCommon(name, recursive);
    }

    private Response deleteCommon(String name, boolean recursive) throws Exception {
        ValidateUtils.checkNullParameter(name == null, "name is null");
        ValidateUtils.checkIllegalParameter(name.isEmpty(), "name not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + name;
        LOG.debug(url);
        if (this.request == null || !(this.request instanceof JsonDeleteRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        if (recursive) {
            this.request.setHeaders(Map.of("X-IBM-Option", "recursive"));
        }
        return RestUtils.getResponse(this.request);
    }

    public Response zfsDelete(String fileSystemName) throws Exception {
        ValidateUtils.checkNullParameter(fileSystemName == null, "file system name is null");
        ValidateUtils.checkIllegalParameter(fileSystemName.isEmpty(), "file system name not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/mfs/zfs/" + fileSystemName;
        LOG.debug(url);
        if (this.request == null || !(this.request instanceof JsonDeleteRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        return RestUtils.getResponse(this.request);
    }
}

