/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ListParams;
import zowe.client.sdk.zosfiles.uss.input.ListZfsParams;
import zowe.client.sdk.zosfiles.uss.response.UssItem;
import zowe.client.sdk.zosfiles.uss.response.UssZfsItem;

public class UssList {
    private static final Logger LOG = LoggerFactory.getLogger(UssList.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssList(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssList(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public List<UssItem> fileList(ListParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getPath().isEmpty(), "params path not specified");
        StringBuilder url = new StringBuilder("https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs");
        url.append("?path=").append(params.getPath().get());
        params.getGroup().ifPresent(group -> url.append("&group=").append(EncodeUtils.encodeURIComponent(group)));
        params.getUser().ifPresent(user -> url.append("&user=").append(EncodeUtils.encodeURIComponent(user)));
        params.getMtime().ifPresent(mtime -> url.append("&mtime=").append(EncodeUtils.encodeURIComponent(mtime)));
        params.getSize().ifPresent(size -> url.append("&size=").append(size));
        params.getName().ifPresent(name -> url.append("&name=").append(EncodeUtils.encodeURIComponent(name)));
        params.getPerm().ifPresent(perm -> url.append("&perm=").append(EncodeUtils.encodeURIComponent(perm)));
        if (params.getSize().isPresent() && params.getType().isPresent()) {
            url.append("&type=f");
        } else {
            params.getType().ifPresent(type -> url.append("&type=").append(type.getValue()));
        }
        params.getDepth().ifPresent(depth -> url.append("&depth=").append(depth));
        if (params.isFilesys()) {
            url.append("&filesys=all");
        }
        if (params.isSymlinks()) {
            url.append("&symlinks=report");
        }
        LOG.debug(url.toString());
        Response response = this.getResponse(url.toString(), params.getMaxLength().orElse(0));
        ArrayList<UssItem> items = new ArrayList<UssItem>();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(String.valueOf(response.getResponsePhrase().orElseThrow(() -> new Exception("error retrieving uss list"))));
        JSONArray jsonArray = (JSONArray)jsonObject.get("items");
        if (jsonArray != null) {
            for (Object jsonObj : jsonArray) {
                items.add(this.parseJsonUssListResponse((JSONObject)jsonObj));
            }
        }
        return items;
    }

    public List<UssZfsItem> zfsList(ListZfsParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getPath().isEmpty() && params.getFsname().isEmpty(), "no path or fsname specified");
        ValidateUtils.checkIllegalParameter(params.getPath().isPresent() && params.getFsname().isPresent(), "specify either path or fsname");
        StringBuilder url = new StringBuilder("https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/mfs");
        params.getPath().ifPresent(path -> url.append("?path=").append(EncodeUtils.encodeURIComponent(path)));
        params.getFsname().ifPresent(fsname -> url.append("?fsname=").append(EncodeUtils.encodeURIComponent(fsname)));
        LOG.debug(url.toString());
        Response response = this.getResponse(url.toString(), params.getMaxLength().orElse(0));
        ArrayList<UssZfsItem> items = new ArrayList<UssZfsItem>();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(String.valueOf(response.getResponsePhrase().orElseThrow(() -> new Exception("error retrieving uss zfs list"))));
        JSONArray jsonArray = (JSONArray)jsonObject.get("items");
        if (jsonArray != null) {
            for (Object jsonObj : jsonArray) {
                items.add(this.parseJsonUssZfsListResponse((JSONObject)jsonObj));
            }
        }
        return items;
    }

    private Response getResponse(String url, int maxLength) throws Exception {
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        if (maxLength > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        return RestUtils.getResponse(this.request);
    }

    private UssItem parseJsonUssListResponse(JSONObject jsonObject) {
        return new UssItem.Builder().name(jsonObject.get("name") != null ? (String)jsonObject.get("name") : null).mode(jsonObject.get("mode") != null ? (String)jsonObject.get("mode") : null).size(jsonObject.get("size") != null ? (Long)jsonObject.get("size") : null).uid(jsonObject.get("uid") != null ? (Long)jsonObject.get("uid") : null).user(jsonObject.get("user") != null ? (String)jsonObject.get("user") : null).gid(jsonObject.get("gid") != null ? (Long)jsonObject.get("gid") : null).group(jsonObject.get("group") != null ? (String)jsonObject.get("group") : null).mtime(jsonObject.get("mtime") != null ? (String)jsonObject.get("mtime") : null).build();
    }

    private UssZfsItem parseJsonUssZfsListResponse(JSONObject jsonObject) {
        StringBuilder modeStr = new StringBuilder();
        try {
            JSONArray modeLst = (JSONArray)jsonObject.get("mode");
            int size = modeLst.size();
            for (int i = 0; i < size; ++i) {
                if (size - 1 == i) {
                    modeStr.append(modeLst.get(i).toString());
                    continue;
                }
                modeStr.append(modeLst.get(i).toString()).append(", ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new UssZfsItem.Builder().name(jsonObject.get("name") != null ? (String)jsonObject.get("name") : null).mountpoint(jsonObject.get("mountpoint") != null ? (String)jsonObject.get("mountpoint") : null).fstname(jsonObject.get("fstname") != null ? (String)jsonObject.get("fstname") : null).status(jsonObject.get("status") != null ? (String)jsonObject.get("status") : null).mode(modeStr.toString()).dev(jsonObject.get("dev") != null ? (Long)jsonObject.get("dev") : null).fstype(jsonObject.get("fstype") != null ? (Long)jsonObject.get("fstype") : null).bsize(jsonObject.get("bsize") != null ? (Long)jsonObject.get("bsize") : null).bavail(jsonObject.get("bavail") != null ? (Long)jsonObject.get("bavail") : null).blocks(jsonObject.get("blocks") != null ? (Long)jsonObject.get("blocks") : null).sysname(jsonObject.get("sysname") != null ? (String)jsonObject.get("sysname") : null).readibc(jsonObject.get("readibc") != null ? (Long)jsonObject.get("readibc") : null).writeibc(jsonObject.get("writeibc") != null ? (Long)jsonObject.get("writeibc") : null).diribc(jsonObject.get("diribc") != null ? (Long)jsonObject.get("diribc") : null).returnedRows(jsonObject.get("returnedRows") != null ? (Long)jsonObject.get("returnedRows") : null).totalRows(jsonObject.get("totalRows") != null ? (Long)jsonObject.get("totalRows") : null).moreRows(jsonObject.get("moreRows") != null ? (Boolean)jsonObject.get("moreRows") : false).build();
    }
}

