/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.MountParams;
import zowe.client.sdk.zosfiles.uss.types.MountActionType;
import zowe.client.sdk.zosfiles.uss.types.MountModeType;

public class UssMount {
    private static final Logger LOG = LoggerFactory.getLogger(UssMount.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssMount(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssMount(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public Response mount(String fileSystemName, String mountPoint, String fsType) throws Exception {
        return this.mountCommon(fileSystemName, new MountParams.Builder().action(MountActionType.MOUNT).mountPoint(mountPoint).fsType(fsType).mode(MountModeType.READ_WRITE).build());
    }

    public Response unmount(String fileSystemName) throws Exception {
        return this.mountCommon(fileSystemName, new MountParams.Builder().action(MountActionType.UNMOUNT).build());
    }

    public Response mountCommon(String fileSystemName, MountParams params) throws Exception {
        ValidateUtils.checkNullParameter(fileSystemName == null, "file system name is null");
        ValidateUtils.checkIllegalParameter(fileSystemName.isEmpty(), "file system name not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getAction().isEmpty(), "params action not specified");
        String action = params.getAction().get().getValue();
        ValidateUtils.checkIllegalParameter("MOUNT".equals(action) && params.getFsType().isEmpty(), "params fsType not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/mfs/" + fileSystemName;
        LOG.debug(url);
        if (this.request == null || !(this.request instanceof JsonPutRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("action", action);
        params.getMountPoint().ifPresent(str -> jsonMap.put("mount-point", str));
        params.getFsType().ifPresent(str -> jsonMap.put("fs-type", str));
        params.getMode().ifPresent(str -> jsonMap.put("mode", str.getValue()));
        StringBuilder jsonStr = new StringBuilder();
        jsonStr.append("{");
        jsonMap.forEach((k, v) -> {
            jsonStr.append("\"").append((String)k).append("\"");
            jsonStr.append(":");
            jsonStr.append("\"").append(v).append("\"");
            jsonStr.append(",");
        });
        StringBuilder jsonFinalStr = new StringBuilder(jsonStr.substring(0, jsonStr.length() - 1));
        jsonFinalStr.append("}");
        LOG.debug(jsonFinalStr.toString());
        this.request.setBody(jsonFinalStr.toString());
        this.request.setUrl(url);
        return RestUtils.getResponse(this.request);
    }
}

