/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.StreamPutRequest;
import zowe.client.sdk.rest.TextPutRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.WriteParams;

public class UssWrite {
    private static final Logger LOG = LoggerFactory.getLogger(UssWrite.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssWrite(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssWrite(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public Response writeText(String fileNamePath, String content) throws Exception {
        return this.writeCommon(fileNamePath, new WriteParams.Builder().textContent(content).build());
    }

    public Response writeBinary(String fileNamePath, byte[] content) throws Exception {
        return this.writeCommon(fileNamePath, new WriteParams.Builder().binaryContent(content).binary(true).build());
    }

    public Response writeCommon(String fileNamePath, WriteParams params) throws Exception {
        ValidateUtils.checkNullParameter(fileNamePath == null, "file name path is null");
        ValidateUtils.checkIllegalParameter(fileNamePath.isEmpty(), "file name path not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + fileNamePath;
        LOG.debug(url);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (params.isBinary()) {
            headers.put("X-IBM-Data-Type", "binary;");
            if (params.getBinaryContent().isEmpty()) {
                LOG.debug("binaryContent is empty");
            }
            if (this.request == null || !(this.request instanceof StreamPutRequest)) {
                this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_STREAM);
            }
            this.request.setBody(params.getBinaryContent().orElse(new byte[0]));
        } else {
            StringBuilder textHeader = new StringBuilder("text");
            params.getFileEncoding().ifPresent(encoding -> textHeader.append(";fileEncoding=").append((String)encoding));
            if (params.isCrlf()) {
                textHeader.append(";crlf=true");
            }
            textHeader.append(";");
            headers.put("X-IBM-Data-Type", textHeader.toString());
            if (params.getTextContent().isEmpty()) {
                LOG.debug("textContent is empty");
            }
            if (this.request == null || !(this.request instanceof TextPutRequest)) {
                this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_TEXT);
            }
            this.request.setBody(params.getTextContent().orElse(""));
        }
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return RestUtils.getResponse(this.request);
    }
}

