/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.TextPutRequest;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.JobUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.SubmitJclParams;
import zowe.client.sdk.zosjobs.input.SubmitJobParams;
import zowe.client.sdk.zosjobs.response.Job;

public class JobSubmit {
    private static final Logger LOG = LoggerFactory.getLogger(JobSubmit.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public JobSubmit(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobSubmit(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public Job submitByJcl(String jcl, String internalReaderRecfm, String internalReaderLrecl) throws Exception {
        return this.submitJclCommon(new SubmitJclParams(jcl, internalReaderRecfm, internalReaderLrecl));
    }

    public Job submitJclCommon(SubmitJclParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJcl().isEmpty(), "jcl not specified");
        ValidateUtils.checkIllegalParameter(params.getJcl().get().isEmpty(), "jcl not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(1);
        headers.put(key, value);
        if (params.getInternalReaderLrecl().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL").get(0);
            headers.put(key, params.getInternalReaderLrecl().get());
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(1);
            headers.put(key, value);
        }
        if (params.getInternalReaderRecfm().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM").get(0);
            headers.put(key, params.getInternalReaderLrecl().get());
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(1);
            headers.put(key, value);
        }
        if (params.getJclSymbols().isPresent()) {
            headers.putAll(this.getSubstitutionHeaders(params.getJclSymbols().get()));
        }
        key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(0);
        value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(1);
        headers.put(key, value);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs";
        LOG.debug(url);
        String body = params.getJcl().get();
        if (this.request == null || !(this.request instanceof TextPutRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_TEXT);
        }
        this.request.setUrl(url);
        this.request.setBody(body);
        this.request.setHeaders(headers);
        Response response = RestUtils.getResponse(this.request);
        return JobUtils.parseJsonJobResponse((JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString()));
    }

    public Job submit(String jobDataSet) throws Exception {
        return this.submitCommon(new SubmitJobParams(jobDataSet));
    }

    public Job submitCommon(SubmitJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobDataSet().isEmpty(), "jobDataSet not specified");
        ValidateUtils.checkIllegalParameter(params.getJobDataSet().get().isEmpty(), "jobDataSet not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs";
        LOG.debug(url);
        String fullyQualifiedDataset = "//'" + EncodeUtils.encodeURIComponent(params.getJobDataSet().get()) + "'";
        HashMap<String, CallSite> jsonMap = new HashMap<String, CallSite>();
        jsonMap.put("file", (CallSite)((Object)fullyQualifiedDataset));
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(String.valueOf(jsonRequestBody));
        if (this.request == null || !(this.request instanceof JsonPutRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(jsonRequestBody.toString());
        if (params.getJclSymbols().isPresent()) {
            this.request.setHeaders(this.getSubstitutionHeaders(params.getJclSymbols().get()));
        }
        Response response = RestUtils.getResponse(this.request);
        return JobUtils.parseJsonJobResponse((JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString()));
    }

    private Map<String, String> getSubstitutionHeaders(Map<String, String> keyValues) throws Exception {
        HashMap<String, String> symbolMap = new HashMap<String, String>();
        for (String string : keyValues.values()) {
            if (string.chars().filter(ch -> ch == 34).count() % 2L != 0L) {
                throw new Exception("Encountered invalid key/value pair. Mismatched quotes.");
            }
            if (string.length() != 0) continue;
            throw new Exception("Encountered invalid key/value pair. Must define a value for key/value pair.");
        }
        for (String string : keyValues.keySet()) {
            String value = keyValues.get(string);
            if (string.length() == 0) {
                throw new Exception("Encountered invalid key/value pair. Must define a key for key/value pair.");
            }
            if (string.length() > 8) {
                throw new Exception("Encountered invalid key/value pair. Key must be 8 characters or less.");
            }
            String string2 = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JCL_SYMBOL_PARTIAL").get(0) + string;
            LOG.debug("JCL Symbol Header: " + string2 + ":" + value);
            symbolMap.put(string2, value);
        }
        return symbolMap;
    }
}

