/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.method;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zoslogs.input.ZosLogParams;
import zowe.client.sdk.zoslogs.response.ZosLogItem;
import zowe.client.sdk.zoslogs.response.ZosLogReply;

public class ZosLog {
    private static final Logger LOG = LoggerFactory.getLogger(ZosLog.class);
    private static final String RESOURCE = "/zosmf/restconsoles/v1/log?";
    private final ZosConnection connection;
    private ZoweRequest request;

    public ZosLog(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosLog(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        if (!(request instanceof JsonGetRequest)) {
            throw new Exception("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosLogReply issueCommand(ZosLogParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String defaultUrl = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + RESOURCE;
        StringBuilder url = new StringBuilder(defaultUrl);
        params.getStartTime().ifPresent(time -> {
            if (ZosLog.isNotValidDate(time)) {
                throw new IllegalArgumentException("startTime date format is invalid");
            }
            DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault());
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(time, formatter);
            url.append("time=").append(zonedDateTime);
        });
        params.getTimeRange().ifPresent(timeRange -> url.append("&timeRange=").append((String)timeRange));
        params.getDirection().ifPresent(direction -> url.append("&direction=").append(direction.getValue()));
        params.getHardCopy().ifPresent(hardCopy -> url.append("&hardcopy=").append(hardCopy.getValue()));
        LOG.debug(url.toString());
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(url.toString());
        Response response = RestUtils.getResponse(this.request);
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString());
        JSONArray jsonArray = new JSONArray();
        if (jsonObject.get("items") != null) {
            jsonArray = (JSONArray)jsonObject.get("items");
        }
        ArrayList<ZosLogItem> zosLogItems = new ArrayList<ZosLogItem>();
        boolean isProcessResponse = params.isProcessResponses();
        jsonArray.forEach(item -> {
            JSONObject itemObj = (JSONObject)item;
            String message = ZosLog.processMessage(itemObj, isProcessResponse);
            ZosLogItem.Builder zosLogItemBuilder = new ZosLogItem.Builder().cart(itemObj.get("cart") != null ? (String)itemObj.get("cart") : null).color(itemObj.get("color") != null ? (String)itemObj.get("color") : null).jobName(itemObj.get("jobName") != null ? (String)itemObj.get("jobName") : null).message(message).messageId(itemObj.get("messageId") != null ? (String)itemObj.get("messageId") : null).replyId(itemObj.get("replyId") != null ? (String)itemObj.get("replyId") : null).system(itemObj.get("system") != null ? (String)itemObj.get("system") : null).type(itemObj.get("type") != null ? (String)itemObj.get("type") : null).subType(itemObj.get("subType") != null ? (String)itemObj.get("subType") : null).time(itemObj.get("time") != null ? (String)itemObj.get("time") : null).timeStamp(itemObj.get("timestamp") != null ? (Long)itemObj.get("timestamp") : 0L);
            zosLogItems.add(zosLogItemBuilder.build());
        });
        return new ZosLogReply(jsonObject.get("timezone") != null ? (Long)jsonObject.get("timezone") : 0L, jsonObject.get("nextTimestamp") != null ? (Long)jsonObject.get("nextTimestamp") : 0L, jsonObject.get("source") != null ? (String)jsonObject.get("source") : null, jsonObject.get("totalitems") != null ? (Long)jsonObject.get("totalitems") : null, zosLogItems);
    }

    private static String processMessage(JSONObject jsonObj, boolean isProcessResponse) {
        try {
            String message = (String)jsonObj.get("message");
            if (isProcessResponse) {
                if (message.contains("\r")) {
                    message = message.replace('\r', '\n');
                }
                if (message.contains("\n\n")) {
                    message = message.replaceAll("\n\n", "\n");
                }
            }
            return message;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isNotValidDate(String str) {
        String patternStr = ".*[0-9]-.*[0-9]-.*[0-9][T].*[0-9][:]*[0-9][:]*[0-9][Z]";
        Pattern pattern = Pattern.compile(".*[0-9]-.*[0-9]-.*[0-9][T].*[0-9][:]*[0-9][:]*[0-9][Z]");
        Matcher matcher = pattern.matcher(str);
        return !matcher.matches();
    }
}

