/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.methods;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.utility.ZosmfUtils;
import zowe.client.sdk.zosmfinfo.response.ZosmfListDefinedSystemsResponse;

public class ZosmfSystems {
    private static final Logger LOG = LoggerFactory.getLogger(ZosmfSystems.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public ZosmfSystems(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfSystems(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        if (!(request instanceof JsonGetRequest)) {
            throw new Exception("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfListDefinedSystemsResponse get() throws Exception {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/resttopology/systems";
        LOG.debug(url);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        Response response = RestUtils.getResponse(this.request);
        return ZosmfUtils.parseListDefinedSystems((JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString()));
    }
}

