/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class StreamGetRequest
extends ZoweRequest {
    public StreamGetRequest(ZosConnection connection) {
        super(connection);
    }

    @Override
    public Response executeRequest() throws UnirestException {
        ValidateUtils.checkNullParameter(this.url == null, "url is null");
        HttpResponse<byte[]> reply = ((GetRequest)Unirest.get(this.url).headers(this.headers)).asBytes();
        if (reply.getStatusText().contains("No Content")) {
            return new Response(reply.getStatusText(), reply.getStatus(), reply.getStatusText());
        }
        return new Response(reply.getBody(), reply.getStatus(), reply.getStatusText());
    }

    @Override
    public void setBody(Object body) throws UnirestException {
        throw new UnirestException("setting body for this request is invalid");
    }

    @Override
    public void setStandardHeaders() {
        this.headers.put("Authorization", "Basic " + EncodeUtils.getAuthEncoding(this.connection));
        this.headers.put("Content-Type", "application/json");
        this.headers.put(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }
}

