/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.util.Optional;
import zowe.client.sdk.core.ZosConnection;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkConnection(ZosConnection connection) {
        if (connection == null || connection.getZosmfPort() == null || connection.getHost() == null || connection.getPassword() == null || connection.getUser() == null || connection.getZosmfPort().isEmpty() || connection.getHost().isEmpty() || connection.getPassword().isEmpty() || connection.getUser().isEmpty()) {
            throw new IllegalStateException("Connection data not setup properly");
        }
    }

    public static void checkIllegalParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new IllegalArgumentException(message.orElse("empty message specified"));
        }
    }

    public static void checkNullParameter(boolean check, String msg) {
        Optional<String> message = Optional.ofNullable(msg);
        if (check) {
            throw new NullPointerException(message.orElse("empty message specified"));
        }
    }
}

